<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', function () {
    return 'Payment System v1.0';
});

Route::post('/callBackTest', function () {
    # Hash Calculate
    $hashParameters = [
        'api_id' => request()->input('apiId'),
        'api_key' => request()->input('apiKey'),
        'user_id' => request()->input('userId'),
        'username' => request()->input('username'),
        'amount' => request()->input('amount'),
        'type' => request()->input('type')
    ];

    if (!empty(request()->input('externalTransactionId')))
        $hashParameters['external_transaction_id'] = request()->input('externalTransactionId');

    $generateHash = hash("sha512", http_build_query($hashParameters));

    return response()->json([
        'status' => 200,
        'message' => 'hello bu bir test',
        'hash' => $generateHash
    ]);
});

Route::get('/gizaPromo', function () {
    return view('gizaPromo');
});

#Route::match(['GET', 'POST'], '/spider', 'SpiderController@index');
#Route::match(['GET', 'POST'], '/payment/lobby', 'PaymentController@getLobby');
#Route::match(['GET', 'POST'], '/maksipara', 'PaymentController@getMaksiPara');
#Route::match(['GET', 'POST'], '/lobby_maksipara', 'PaymentController@getLobbyMaksi');
#Route::match(['GET', 'POST'], '/payment/success', 'PaymentController@getPaymentSuccess');
#Route::match(['GET', 'POST'], '/payment/page/{methodId}', 'PaymentController@getPaymentPage');
#Route::match(['GET', 'POST'], '/testDraw', 'PaymentController@testDraw');
#Route::match(['GET', 'POST'], '/testDeposit', 'PaymentController@testDeposit');
#Route::match(['GET', 'POST'], '/testPay', 'PanelController@testPay');
#Route::match(['GET', 'POST'], '/testDate', 'PanelController@testDate');
#Route::match(['GET', 'POST'], '/test_code', 'TestController@otoPaPara');
#Route::match(['GET', 'POST'], '/xx-seamless', 'TestController@irrSeamless');
#Route::match(['GET', 'POST'], '/testPay', 'TestController@testPay');
Route::match(['GET', 'POST'], '/testIndex', 'TestController@index');

### Version 2.0 API ###
Route::post('/payment/draw/papara', 'PayController@createDrawPaParaByApi');
Route::post('/payment/draw/bank-transfer', 'PayController@createDrawBankTransferByApi');
Route::post('/payment/deposit/bank-transfer', 'PayController@createDepositBankTransferByApi');
Route::post('/payment/deposit/papara', 'PayController@createDepositPaParaByApi');
Route::post('/payment/deposit/lobby', 'PayController@createDepositLobbyByApi');
Route::post('/payment/api/banks', 'ApiController@getBankList');
Route::get('/payment/check/status', 'PayController@getPaymentCheckStatus');

### ProNet Gaming CallBack ###
Route::match(['GET', 'POST'], '/giza-callback', 'GizaBetController@getProNetCallBack');

### ProNet Gaming Auth ###
Route::match(['GET', 'POST'], '/iframe/{siteName}/{userId}', 'IframeController@index');

### PushBullet API ###
Route::match(['GET', 'POST'], '/pushBulletInsertApi', 'PushBulletController@pushApi');

### Sx Controller ###
Route::match(['GET', 'POST'], '/sx/callback', 'SxController@index');
Route::match(['GET', 'POST'], '/sx/test', 'SxController@test');

### New Version Payment Page ###
Route::match(['GET', 'POST'], '/direct/{apiKey}', 'PayController@getDirectPage');
Route::match(['GET', 'POST'], '/pay/{methodId}', 'PayController@getPayPage');
Route::match(['GET', 'POST'], '/pay', 'PayController@getPayLobby');
Route::post('/Methods/BankTransfer/Pay', 'PayController@getPayBankTransfer');
Route::post('/Methods/BankTransfer/Check', 'PayController@getCheckBankTransfer');
Route::post('/Methods/Papara/Pay', 'PayController@getPayPaParaTransfer');
Route::post('/Methods/Papara/Check', 'PayController@getCheckPaParaTransfer');
#Route::match(['GET', 'POST'], '/pay', 'PayController@getErrorPage');

/*Route::group(['prefix' => '/api'], function () {
    Route::match(['GET', 'POST'], '/payment/create', 'PaymentController@createPayment');
    Route::match(['GET', 'POST'], '/player/register', 'PaymentController@createPlayer');
    Route::match(['GET', 'POST'], '/bank_account/{typeId}/{bankId}', 'PaymentController@getAccountDetails');
    Route::match(['GET', 'POST'], '/bank_accounts/{typeId}', 'PaymentController@getAccountsDetails');
});*/

### SandBox ###
Route::match(['GET', 'POST'], '/sandbox/deposit/{methodId}', 'SandBoxController@depositIndex');
Route::match(['GET', 'POST'], '/sandbox/deposit-callback', 'SandBoxController@depositCallBack');
Route::match(['GET', 'POST'], '/sandbox/withdraw/{methodId}', 'SandBoxController@withdrawIndex');
Route::match(['GET', 'POST'], '/sandbox/withdraw-callback', 'SandBoxController@withdrawCallBack');

### Demo Page ###
Route::group(['prefix' => '/demo-tool'], function () {
    Route::post('/create-payment-page', 'DemoController@store');
    Route::get('/{theme?}', 'DemoController@index');
});

/*Route::group(['prefix' => '/seamless'], function () {
    Route::match(['GET', 'POST'], '/jeton/payin', 'SeamlessController@methodJetonPayIn');
    Route::match(['GET', 'POST'], '/jeton/payout', 'SeamlessController@methodJetonPayOut');
});*/

### Admin Panel ###
Route::group(['prefix' => '/admin'], function () {
    Route::match(['GET', 'POST'], '/', 'PanelController@getLogin');
    Route::match(['GET', 'POST'], '/login', 'PanelController@getLogin');
    Route::match(['GET', 'POST'], '/ga_login', 'PanelController@getLoginGoogleAuthenticator');
    Route::match(['GET', 'POST'], '/dashboard', 'PanelController@getDashboard');
    Route::match(['GET', 'POST'], '/logout', 'PanelController@getLogout');
    Route::match(['GET', 'POST'], '/profile', 'PanelController@getProfile');
    Route::match(['GET', 'POST'], '/g2a', 'PanelController@getGoogleTwoFactor');
    Route::match(['GET', 'POST'], '/g2a/disable', 'PanelController@disabledGoogleTwoFactor');
    Route::match(['GET', 'POST'], '/get-bank-accounts', 'PanelController@getBankAccountsForWebSiteAdmin');
    Route::match(['GET', 'POST'], '/create-manual-transaction', 'PanelController@createManualTransaction');
    Route::post('/manual-transaction-edit', 'PanelController@updateManualTransaction');

    Route::group(['prefix' => '/account-management'], function () {
        Route::match(['GET', 'POST'], '/banks', 'PanelController@getBanks');
        Route::match(['GET', 'POST'], '/banks/create', 'PanelController@getBankCreate');
        Route::match(['GET', 'POST'], '/banks/edit/{id}', 'PanelController@getBankEdit');

        Route::match(['GET', 'POST'], '/accounts', 'PanelController@getAccounts');
        Route::match(['GET', 'POST'], '/accounts/list', 'PanelController@getAccountList');
        Route::match(['GET', 'POST'], '/accounts/create', 'PanelController@getAccountCreate');
        Route::match(['GET', 'POST'], '/accounts/edit/{id}', 'PanelController@getAccountEdit');
        Route::match(['GET', 'POST'], '/accounts/status/{id}/{status}', 'PanelController@setAccountStatus');
        Route::match(['GET', 'POST'], '/accounts/check-mail-server', 'PanelController@getAccountMailCheck');

        Route::match(['GET', 'POST'], '/deposit-range', 'PanelController@getDepositRange');
        Route::match(['GET', 'POST'], '/deposit-range/create', 'PanelController@createDepositRange');
        Route::match(['GET', 'POST'], '/deposit-range/edit/{id}', 'PanelController@editDepositRange');
    });

    Route::group(['prefix' => '/sites'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getSites');
        Route::match(['GET', 'POST'], '/create', 'PanelController@getSiteCreate');
        Route::match(['GET', 'POST'], '/edit/{id}', 'PanelController@getSiteEdit');
    });

    Route::group(['prefix' => '/whitelist-ip'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getWhiteListIp');
        Route::match(['GET', 'POST'], '/create', 'PanelController@createWhiteListIp');
        Route::match(['GET', 'POST'], '/edit/{id}', 'PanelController@updateWhiteListIp');
    });

    Route::group(['prefix' => '/payment-methods'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getPaymentMethods');
        Route::match(['GET', 'POST'], '/edit/{id}', 'PanelController@updatePaymentMethod');
    });

    Route::group(['prefix' => '/operators'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getOperators');
        Route::match(['GET', 'POST'], '/create', 'PanelController@getOperatorCreate');
        Route::match(['GET', 'POST'], '/edit/{id}', 'PanelController@getOperatorEdit');
        Route::match(['GET', 'POST'], '/ga/{id}', 'PanelController@getOperatorGoogleAuthenticator');
        Route::match(['GET', 'POST'], '/ga/disable/{id}', 'PanelController@disableOperatorGoogleAuthenticator');
    });

    Route::group(['prefix' => '/transactions'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getTransactions');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getTransactionList');
        Route::match(['GET', 'POST'], '/count', 'PanelController@getTransactionsCount');
        Route::match(['GET', 'POST'], '/check-auto', 'PanelController@checkAutoTransaction');
        Route::match(['GET', 'POST'], '/detail/{id}', 'PanelController@getTransactionDetail');
        Route::match(['GET', 'POST'], '/status/{id}', 'PanelController@getTransactionStatus');
        Route::match(['GET', 'POST'], '/export-excel', 'PanelController@exportExcelTransactions');
    });

    Route::group(['prefix' => '/reports'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getReports');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getReportList');
    });

    Route::group(['prefix' => '/players'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getPlayers');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getPlayerList');
        Route::match(['GET', 'POST'], '/show/{id}', 'PanelController@getPlayerShow');
    });

    Route::group(['prefix' => '/settings'], function () {
        Route::get('/', 'PanelController@getSettings');
        Route::post('/update', 'PanelController@updateSettings');
    });

    Route::group(['prefix' => '/logs'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getLogs');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getLogList');
    });

    Route::group(['prefix' => '/api_logs'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getApiLogs');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getApiLogList');
    });

    Route::group(['prefix' => '/cron_jobs'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getCronJobs');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getCronJobList');
        Route::get('/run/{id}', 'PanelController@runCronJob');
    });

    Route::group(['prefix' => '/push-bullet'], function () {
        Route::match(['GET', 'POST'], '/', 'PanelController@getPushBullet');
        Route::match(['GET', 'POST'], '/list', 'PanelController@getPushBulletList');
        Route::match(['GET', 'POST'], '/detail/{id}', 'PanelController@getPushBulletDetail');
        Route::get('/delete/{id}', 'PanelController@getPushBulletDelete');
    });

    Route::group(['prefix' => '/statistics'], function () {
        Route::group(['prefix' => '/operators'], function () {
            Route::match(['GET', 'POST'], '/', 'PanelController@getStatisticOperators');
            Route::match(['GET', 'POST'], '/list', 'PanelController@getApiLogList');
        });
    });
});

### Cron Jobs ###
Route::group(['prefix' => '/cron'], function () {
    Route::group(['prefix' => '/hourly'], function () {
        Route::get('/delete-empty-transactions', 'CronJobController@deleteEmptyTransactions');
    });

    Route::group(['prefix' => '/minutely'], function () {
        Route::get('/sx-match-bank-ids', 'CronJobController@sxMatchBankIds');
        Route::get('/sx-match-transaction-ids', 'CronJobController@sxMatchTransactionIds');
        Route::get('/sx-check-vault-transfer', 'CronJobController@sxCheckVaultTransfer');
        Route::get('/sx-run-callback', 'CronJobController@sxRunCallBack');
        Route::get('/declined-auto-transactions', 'CronJobController@declinedAutoTransactions');
    });
});
