<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Sandbox Test Tool">
    <meta name="author" content="BetModule">
    <meta name="hash" content="{{ request()->input('hash') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>SandBox - {{ env('PAY_WEBSITE_NAME') }}</title>
    <link href="/sandbox/app.css" rel="stylesheet">
</head>
<body>
<div class="d-flex flex-column flex-md-row align-items-center p-3 px-md-4 mb-3 bg-white border-bottom box-shadow">
    <h5 class="my-0 mr-md-auto font-weight-normal">{{ env('PAY_WEBSITE_NAME') }}</h5>
</div>
<div class="pricing-header px-3 py-3 pt-md-5 pb-md-4 mx-auto text-center">
    <h1 class="display-4">Withdraw SandBox</h1>
    <p class="lead">Select one of below buttons</p>
</div>
<div class="container">
    @if(empty($transaction))
        <div class="card-deck mb-3 text-center">
            <div class="card mb-4 box-shadow">
                <div class="card-header">
                    <h4 class="my-0 font-weight-normal">Post-Payment Page</h4>
                </div>
                <div class="card-body">
                    <h1 class="card-title pricing-card-title">
                        Payment was not found.
                    </h1>
                </div>
            </div>
        </div>
    @else
        @if($transaction->is_success == 0)
            <div class="card-deck mb-3 text-center">
                <div class="card mb-4 box-shadow">
                    <div class="card-header">
                        <h4 class="my-0 font-weight-normal">Unsuccessful payment</h4>
                    </div>
                    <div class="card-body">
                        <a href="javascript:void(0);" onclick="sandBoxDrawFail();">
                            <button type="button" class="btn btn-lg btn-block btn-danger">Unsuccessful</button>
                        </a>
                    </div>
                </div>
                <div class="card mb-4 box-shadow">
                    <div class="card-header">
                        <h4 class="my-0 font-weight-normal">Successful payment</h4>
                    </div>
                    <div class="card-body">
                        <a href="javascript:void(0);" onclick="sandBoxDrawSuccess();">
                            <button type="button" class="btn btn-lg btn-block btn-success">Successful</button>
                        </a>
                    </div>
                </div>
            </div>
        @else
            <div class="card-deck mb-3 text-center">
                <div class="card mb-4 box-shadow">
                    <div class="card-header">
                        <h4 class="my-0 font-weight-normal">Post-Payment Page</h4>
                    </div>
                    <div class="card-body">
                        <h1 class="card-title pricing-card-title">
                            Payment has already been done.
                        </h1>
                    </div>
                </div>
            </div>
        @endif
    @endif

    <div id="responseSandBox"></div>
</div>

<script src="/sandbox/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>window.jQuery || document.write('<script src="/js/vendor/jquery-slim.min.js"><\/script>')</script>
<script src="/sandbox/popper.min.js"></script>
<script src="/sandbox/app.js"></script>
<script src="/sandbox/holder.min.js"></script>
<script src="/assets/js/app.js"></script>
<script>
    Holder.addTheme('thumb', {
        bg: '#55595c',
        fg: '#eceeef',
        text: 'Thumbnail'
    });
</script>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-178268478-1"></script>
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'UA-178268478-1');
</script>
</body>
</html>
