@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="row" style="margin: 20px 0 20px;">
            <div class="col-lg-10">
                <h5 style="margin-top: 10px;">IP Adresiniz : ({{ \App\WhiteListIp::getIpAddress() }})</h5>
            </div>

            <div class="col-lg-2 text-right">
                <a href="{{ url('/admin/whitelist-ip/create') }}" class="btn btn-warning btn-lg btn-block">Yeni Kayıt Oluştur</a>
            </div>
        </div>

        <section class="paper-card">
            <div class="row">
                <div class="col-lg-12">
                    <table id="example2" class="table table-bordered table-hover data-tables" data-page-length="25" data-order="[[ 0, &quot;desc&quot; ]]">
                        <thead>
                        <tr>
                            <th style="width: 10px">#</th>
                            <th>IP Adresi</th>
                            <th>Açıklama</th>
                            <th>Durum</th>
                            <th>Oluşturma Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($whitelist_ip as $wli)
                            <tr>
                                <td>{{ $wli->id }}</td>
                                <td>{{ $wli->ip_address }}</td>
                                <td>{{ $wli->description }}</td>
                                <td>
                                    @if($wli->status)
                                        <span class="badge text-white bg-green">Aktif</span>
                                    @else
                                        <span class="badge text-white bg-red">Pasif</span>
                                    @endif
                                </td>
                                <td>{{ $wli->created_at }}</td>
                                <td>
                                    <a href="{{ url('/admin/whitelist-ip/edit/' . $wli->id) }}">
                                        <i class="icon-pencil"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.col -->
        </section>
    </div>
</div>

@include('panel.includes.footer')
