@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="animatedParent animateOnce">
            <div class="container-fluid my-3">
                <div class="row">
                    @if($message = Session::get('error'))
                    <div class="col-md-12">
                        <div class="alert alert-danger alert-block">
                            <button type="button" class="close" data-dismiss="alert">×</button>
                            <strong>{{ $message }}</strong>
                        </div>
                    </div>
                    @endif

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body b-b">
                                <form method="POST" action="">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                    <input type="hidden" name="method" value="api">

                                    <div class="form-group">
                                        <label for="name" class="col-form-label">Site Adı</label>
                                        <input type="text" class="form-control" id="name" name="name" value="{{ $detail->name }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="code" class="col-form-label">Site Kodu</label>
                                        <input type="text" class="form-control" id="code" value="{{ $detail->code }}" disabled>
                                    </div>

                                    <div class="form-group">
                                        <label for="seamless_url" class="col-form-label">Seamless URL</label>
                                        <input type="text" class="form-control" id="seamless_url" name="seamless_url" value="{{ $detail->seamless_url }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="return_url" class="col-form-label">Geri Dönüş URL URL (Olumlu)</label>
                                        <input type="text" class="form-control" id="return_url" name="return_url" value="{{ $detail->return_url }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="return_url_fail" class="col-form-label">Geri Dönüş URL URL (Olumsuz)</label>
                                        <input type="text" class="form-control" id="return_url_fail" name="return_url_fail" value="{{ $detail->return_url_fail }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="platform" class="col-form-label">Platform</label>
                                        <select id="platform" name="platform" class="form-control">
                                            <option value="1" {{ $detail->platform == 1 ? 'selected' : '' }}>JoyBet</option>
                                            <option value="2" {{ $detail->platform == 2 ? 'selected' : '' }}>BetConstruct</option>
                                            <option value="3" {{ $detail->platform == 3 ? 'selected' : '' }}>Pronet Gaming</option>
                                            <option value="4" {{ $detail->platform == 4 ? 'selected' : '' }}>BetWorkSpace</option>
                                            <option value="5" {{ $detail->platform == 5 ? 'selected' : '' }}>BetAndWorks</option>
                                            <option value="6" {{ $detail->platform == 6 ? 'selected' : '' }}>Rest/Pas</option>
                                            <option value="7" {{ $detail->platform == 7 ? 'selected' : '' }}>BetModule</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="environment" class="col-form-label">Environment</label>
                                        <select id="environment" name="environment" class="form-control">
                                            <option value="1" {{ $detail->environment == 1 ? 'selected' : '' }}>Production</option>
                                            <option value="2" {{ $detail->environment == 2 ? 'selected' : '' }}>Test</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">Havale/EFT Tipi</label>
                                        <select id="status" name="is_bt_type" class="form-control">
                                            <option value="0" {{ $detail->is_bt_type == 0 ? 'selected' : '' }}>Varsayılan</option>
                                            <option value="1" {{ $detail->is_bt_type == 1 ? 'selected' : '' }}>Havale/EFT Form</option>
                                            <option value="2" {{ $detail->is_bt_type == 2 ? 'selected' : '' }}>Havale/EFT Manuel</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">Papara Tipi</label>
                                        <select id="status" name="is_p_type" class="form-control">
                                            <option value="0" {{ $detail->is_p_type == 0 ? 'selected' : '' }}>Varsayılan</option>
                                            <option value="1" {{ $detail->is_p_type == 1 ? 'selected' : '' }}>PaPara Form</option>
                                            <option value="2" {{ $detail->is_p_type == 2 ? 'selected' : '' }}>PaPara Manuel</option>
                                            <option value="3" {{ $detail->is_p_type == 3 ? 'selected' : '' }}>Otomatik PaPara</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">PaPara IBAN Aktif Mi?</label>
                                        <select id="status" name="is_pp_type" class="form-control">
                                            <option value="1" {{ $detail->is_pp_type == 1 ? 'selected' : '' }}>Pasif</option>
                                            <option value="0" {{ $detail->is_pp_type == 0 ? 'selected' : '' }}>Aktif</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">Durum</label>
                                        <select id="status" name="status" class="form-control">
                                            <option value="1" {{ $detail->status == 1 ? 'selected' : '' }}>Aktif</option>
                                            <option value="0" {{ $detail->status == 0 ? 'selected' : '' }}>Pasif</option>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body b-b">
                                <form method="POST" action="">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                    <input type="hidden" name="method" value="commission">

                                    @foreach($paymentMethods as $pm)
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="payment_status_{{ $pm->id }}" class="col-form-label">{{ $pm->type == 1 ? 'Yatırım' : 'Çekim' }} Durumu: {{ $pm->name }}</label>
                                                    <select id="payment_status_{{ $pm->id }}" name="payment_status_{{ $pm->id }}" class="form-control">
                                                        <option value="1">Aktif</option>
                                                        <option value="0">Pasif</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="commission_{{ $pm->id }}" class="col-form-label">{{ $pm->type == 1 ? 'Yatırım' : 'Çekim' }} Komisyonu: {{ $pm->name }}</label>
                                                    <input type="text" class="form-control" id="commission_{{ $pm->id }}" name="commission_{{ $pm->id }}" value="{{ \App\SiteCommission::getCommission($detail->id, $pm->id) }}">
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach

                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('panel.includes.footer')
