@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="animatedParent animateOnce">
            <div class="container-fluid my-3">
                <div class="row">
                    @if($message = Session::get('error'))
                    <div class="col-md-12">
                        <div class="alert alert-danger alert-block">
                            <button type="button" class="close" data-dismiss="alert">×</button>
                            <strong>{{ $message }}</strong>
                        </div>
                    </div>
                    @endif

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body b-b">
                                <form method="POST" action="">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                                    <div class="form-group">
                                        <label for="role_id" class="col-form-label">Yetki</label>
                                        <select id="role_id" name="role_id" class="form-control">
                                            <option value="1" {{ $detail->role_id == 1 ? 'selected' : '' }}>Supervisor</option>
                                            <option value="2" {{ $detail->role_id == 2 ? 'selected' : '' }}>Agent</option>
                                            <option value="3" {{ $detail->role_id == 3 ? 'selected' : '' }}>Website Admin</option>
                                            <option value="4" {{ $detail->role_id == 4 ? 'selected' : '' }}>Website Operator</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="api_id" class="col-form-label">Site Adı</label>
                                        <select id="api_id" name="api_id" class="form-control">
                                            <option value="">Seçiniz</option>
                                            @foreach($sites as $site)
                                                <option value="{{ $site->id }}" {{ $detail->api_id == $site->id ? 'selected' : '' }}>{{ $site->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="color: red">Not: Sadece Website Admin Oluştururken Bu Seçimi Yapınız</span>
                                    </div>

                                    <div class="form-group">
                                        <label for="username" class="col-form-label">Kullanıcı Adı</label>
                                        <input type="text" class="form-control" id="username" name="username" value="{{ $detail->username }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="password" class="col-form-label">Parola</label>
                                        <input type="password" class="form-control" id="password" name="password">
                                        <span style="color: red">Not: Eğer ki parola değiştirmek istemiyorsanız boş bırakınız.</span>
                                    </div>

                                    <div class="form-group">
                                        <label for="email" class="col-form-label">E-mail</label>
                                        <input type="email" class="form-control" id="email" name="email" value="{{ $detail->email }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="first_name" class="col-form-label">İsim</label>
                                        <input type="text" class="form-control" id="first_name" name="first_name" value="{{ $detail->first_name }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="last_name" class="col-form-label">Soyisim</label>
                                        <input type="text" class="form-control" id="last_name" name="last_name" value="{{ $detail->last_name }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="access_contact" class="col-form-label">İletişim Bilgisi Görebilir mi?</label>
                                        <select id="access_contact" name="access_contact" class="form-control">
                                            <option value="1" {{ $detail->access_contact == 1 ? 'selected' : '' }}>Evet</option>
                                            <option value="0" {{ $detail->access_contact == 0 ? 'selected' : '' }}>Hayır</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="access_manuel_transaction" class="col-form-label">Talep Oluştur Aktif olsun mu?</label>
                                        <select id="access_manuel_transaction" name="access_manuel_transaction" class="form-control">
                                            <option value="1" {{ $detail->access_manuel_transaction == 1 ? 'selected' : '' }}>Evet</option>
                                            <option value="0" {{ $detail->access_manuel_transaction == 0 ? 'selected' : '' }}>Hayır</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="access_push_bullet" class="col-form-label">Push Bullet Aktif olsun mu?</label>
                                        <select id="access_push_bullet" name="access_push_bullet" class="form-control">
                                            <option value="1" {{ $detail->access_push_bullet == 1 ? 'selected' : '' }}>Evet</option>
                                            <option value="0" {{ $detail->access_push_bullet == 0 ? 'selected' : '' }}>Hayır</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">Durum</label>
                                        <select id="status" name="status" class="form-control">
                                            <option value="1" {{ $detail->status == 1 ? 'selected' : '' }}>Aktif</option>
                                            <option value="0" {{ $detail->status == 0 ? 'selected' : '' }}>Pasif</option>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('panel.includes.footer')
