@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid my-3">
        <div class="d-flex row">
            <div class="col-md-12">
                <!-- Tooltip -->
                <div class="card my-3 shadow no-b r-0">
                    <div class="card-header white">
                        <h6>
                            Filtreleme
                            <span class="float-right" style="color: #ed5564;">
                                Toplam İşlem Sayısı: <b id="paginationCount">0</b>
                            </span>
                        </h6>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" id="transactionForm">
                            <input type="hidden" name="page" value="1" />
                            <div class="form-row">
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Başlangıç Tarihi</label>
                                    <input type="text" name="filter_start_date" class="date-time-picker form-control" data-options='{"format":"Y-m-d H:i"}' placeholder="Başlangıç Tarihi" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Bitiş Tarihi</label>
                                    <input type="text" name="filter_end_date" class="date-time-picker form-control" data-options='{"format":"Y-m-d H:i"}' placeholder="Bitiş Tarihi" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">İşlem ID</label>
                                    <input type="text" name="transaction_id" class="form-control" placeholder="Örnek: 1024" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Oyuncu</label>
                                    <input type="text" name="player_q" class="form-control" placeholder="Örnek: Ahmet Tekin" />
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Tip</label>
                                    <select id="inputState" name="type_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        <option value="1" {{ request()->input('type_id') == 1 ? 'selected' : '' }}>Yatırım</option>
                                        <option value="2" {{ request()->input('type_id') == 2 ? 'selected' : '' }}>Çekim</option>
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Durum</label>
                                    <select id="inputState" name="status" class="form-control">
                                        <option value="">Hepsi</option>
                                        <option value="0" {{ request()->input('status') == '0' ? 'selected' : '' }}>Yeni Talep</option>
                                        <option value="1" {{ request()->input('status') == 1 ? 'selected' : '' }}>Onaylandı</option>
                                        <option value="2" {{ request()->input('status') == 2 ? 'selected' : '' }}>Rededildi</option>
                                        <option value="3" {{ request()->input('status') == 3 ? 'selected' : '' }}>Kontrol Ediliyor</option>
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Banka</label>
                                    <select id="inputState" name="bank_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}" {{ request()->input('bank_id') == $bank->id ? 'selected' : '' }}>{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">Ödeme Yöntemi</label>
                                    <select id="inputState" name="method_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($paymentMethods as $paymentMethod)
                                            <option value="{{ $paymentMethod->id }}" {{ request()->input('method_id') == $paymentMethod->id ? 'selected' : '' }}>[{{ $paymentMethod->type == 1 ? 'Yatırım' : 'Çekim' }}] {{ $paymentMethod->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">Yatırım Aralığı</label>
                                    <select id="inputState" name="deposit_range_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($depositRanges as $depositRange)
                                            <option value="{{ $depositRange->id }}" {{ request()->input('deposit_range_id') == $depositRange->id ? 'selected' : '' }}>{{ $depositRange->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">İşlem Yapan</label>
                                    <select id="inputState" name="process_user_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($operators as $operator)
                                            <option value="{{ $operator->id }}" {{ request()->input('process_user_id') == $operator->id ? 'selected' : '' }}>{{ $operator->username }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip01">Min Miktar</label>
                                    <input type="text" name="min_amount" class="form-control" placeholder="Örnek: 100" />
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip01">Max Miktar</label>
                                    <input type="text" name="max_amount" class="form-control" placeholder="Örnek: 1000" />
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Site</label>
                                    <select id="inputState" name="api_id" class="form-control">
                                        @if($user->role_id == 1 || $user->role_id == 2)
                                            <option value="">Hepsi</option>
                                        @endif

                                        @foreach($sites as $site)
                                            <option value="{{ $site->id }}" {{ request()->input('api_id') == $site->id ? 'selected' : '' }}>{{ $site->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!--<div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">Oyuncu</label>
                                    <select class="custom-select select2" name="player_id">
                                        <option value="">Hepsi</option>
                                        <option value="1">orhanbhr</option>
                                        <option value="1">mertweb</option>
                                        <option value="2">test1</option>
                                        <option value="3">test2</option>
                                    </select>
                                </div>-->
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip02">Filtereleme</label>
                                    <button class="btn btn-primary" type="button" id="transactionFilter">GETİR</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- #END# Tooltip -->
            </div>

            <div class="col-lg-8">
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Site Adı</th>
                                    <th>Tip</th>
                                    <th>Oyuncu</th>
                                    <th>Yöntem</th>
                                    <th>Miktar</th>
                                    <th>Durum</th>
                                    <th>İşlem Tarihi</th>
                                </tr>
                                </thead>
                                <tbody id="loadTransactions">
                                    <!-- loading.. -->
                                </tbody>
                            </table>

                            <div id="Pagination" class="pagination" style="float: left;"></div>

                            <div id="downloadFiles" style="float: right;">
                                <button type="button" class="btn btn-success btn-sm" id="export-to-excel">
                                    Excel İndir
                                </button>
                                <button type="button" class="btn btn-warning btn-sm" id="export-to-pdf">
                                    PDF İndir
                                </button>
                                <form action="/admin/transactions/export-excel" method="post" id="export-excel-form">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                    <input type="hidden" id="excelParams" name="params" value="" />
                                </form>
                                <form action="/admin/transactions/export-pdf" method="post" id="export-pdf-form">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                    <input type="hidden" id="pdfParams" name="params" value="" />
                                </form>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <div class="col-lg-4">
                <div class="errors" style="display: none;">
                    <!-- loading... -->
                </div>
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12" id="loadDetail">
                            <span>Talep Bulunamadı ya da Seçim Yapılmadı. Lütfen sol taraftaki işlemler listesinden seçim yapınız..</span>
                        </div>
                        <!-- /.col -->
                </section>
            </div>
        </div>
    </div>
</div>

<style>
    #type1 {
        background: #64b764;
        color: #fff;
    }

    #type2 {
        background: #ef6767;
        color: #fff;
    }

    #type1:hover {
        background-color: #449844 !important;
    }

    #type2:hover {
        background-color: #cc5252 !important;
    }
</style>

@include('panel.includes.footer')
