@if($user->role_id != 3)
    @if($transaction->is_success == 0 || $transaction->is_success == 3)
        <div class="row">
            <div class="col-lg-4">
                @if($transaction->is_success != 3)
                    <button type="button" process-id="{{ $transaction->id }}" id="checkingTransaction" class="btn btn-info btn-lg btn-block">KONTROL ET</button>
                @endif
            </div>
            @if(env('SX_STATUS') == 1)
                @if($transaction->is_success == 3 && $transaction->transaction_type == 3)
                    <div class="col-lg-4">
                        <button type="button" process-id="{{ $transaction->id }}" id="declinedTransaction" class="btn btn-danger btn-lg btn-block">IPTAL ET</button>
                    </div>
                    <div class="col-lg-4">
                        <button type="button" process-id="{{ $transaction->id }}" id="approvedTransaction" class="btn btn-success btn-lg btn-block">ONAYLA</button>
                    </div>
                @else
                    @if($transaction->transaction_type != 3)
                    <div class="col-lg-4">
                        <button type="button" process-id="{{ $transaction->id }}" id="declinedTransaction" class="btn btn-danger btn-lg btn-block">IPTAL ET</button>
                    </div>
                    <div class="col-lg-4">
                        <button type="button" process-id="{{ $transaction->id }}" id="approvedTransaction" class="btn btn-success btn-lg btn-block">ONAYLA</button>
                    </div>
                    @endif
                @endif
            @else
                <div class="col-lg-4">
                    <button type="button" process-id="{{ $transaction->id }}" id="declinedTransaction" class="btn btn-danger btn-lg btn-block">IPTAL ET</button>
                </div>
                <div class="col-lg-4">
                    <button type="button" process-id="{{ $transaction->id }}" id="approvedTransaction" class="btn btn-success btn-lg btn-block">ONAYLA</button>
                </div>
            @endif
        </div>

        <br />
    @endif

    @if($transaction->is_success != 2)
        <div id="payNoteTransaction" style="display: none;">
            <textarea name="pay_note" class="form-control" placeholder="Red edildiği taktirde, lütfen açıklama yapınız." style="height: 70px;" spellcheck="false"></textarea>

            <br />
        </div>
    @endif
@endif

<table id="example2" class="table table-bordered table-hover">
    <tbody>

    @if($site->platform == 1)
        <!--<tr>
            <td colspan="2">
                <a href="https://joybet141.com/admin/customer/balance/id/{{ $transaction->player->external_user_id }}" target="_blank" class="btn btn-success btn-lg btn-block">JOYBET PROFİLİ GÖR</a>
            </td>
        </tr>-->
    @endif

    @if(!empty($transaction->player_id))
        <tr>
            <th>Oyuncu</th>
            <td><a href="/admin/players/show/{{ $transaction->player_id }}">{{ $transaction->player->username }} ({{ $transaction->player->first_name . ' '. $transaction->player->last_name }})</a></td>
        </tr>
    @endif

    @if(!empty($transaction->transaction_type))
        <tr>
            <th>Ödeme Yöntemi</th>
            <td>{{ $paymentMethod->name }}</td>
        </tr>
    @endif

    @if(!empty($transaction->bank_id))
        <tr>
            <th>Banka</th>
            <td>{{ \App\Bank::getBankName($transaction->bank_id) }}</td>
        </tr>
    @endif

    @if(!empty($bankAccount))
        @if($paymentMethod->id == 1)
            @if(!empty($bankAccount->banks))
                <tr>
                    <th>Hesap Bilgisi</th>
                    <td>
                        Banka Adı : {{ $bankAccount->banks->name ?? '' }}<br />
                        Hesap Sahibi : {{ $bankAccount->account_owner ?? '' }}<br />
                        Hesap Numarası : {{ $bankAccount->account_number ?? '' }}<br />
                        Şube Kodu : {{ $bankAccount->branch_code ?? '' }}<br />
                        IBAN : {{ $bankAccount->iban ?? '' }}
                    </td>
                </tr>
            @endif
        @else
            @if($bankAccount->is_pp_iban == 1)
                <tr>
                    <th>Hesap Bilgisi</th>
                    <td>
                        Banka Adı : {{ $bankAccount->banks->name ?? '' }}<br />
                        Hesap Sahibi : {{ $bankAccount->account_owner ?? '' }}<br />
                        Hesap Numarası : {{ $bankAccount->account_number ?? '' }}<br />
                        Şube Kodu : {{ $bankAccount->branch_code ?? '' }}<br />
                        IBAN : {{ $bankAccount->iban ?? '' }}
                    </td>
                </tr>
            @else
                <tr>
                    <th>Hesap Bilgisi</th>
                    <td>
                        Hesap Sahibi : {{ $bankAccount->account_owner }}<br />
                        Hesap Numarası : {{ $bankAccount->account_number }}<br />
                    </td>
                </tr>
            @endif
        @endif
    @endif

    @foreach($extraParams as $key => $value)
        @if($key == 'method_id')
            <tr>
                <th>{{ trans('main.' . $key) }}</th>
                <td>{{ $paymentMethod->name }}</td>
            </tr>
        @elseif($key == 'api_id')
            <tr>
                <th>{{ trans('main.' . $key) }}</th>
                <td>{{ $site->name }}</td>
            </tr>
        @elseif($key == 'bank_id' && ($paymentMethod->id == 1 || $paymentMethod->id == 2 || $paymentMethod->id == 7))
            <tr>
                <th>{{ trans('main.' . $key) }}</th>
                <td>{{ \App\Bank::getBankName($value) }}</td>
            </tr>
        @else
            <tr>
                <th>{{ trans('main.' . $key) }}</th>
                <td>{{ $value }}</td>
            </tr>
        @endif
    @endforeach

    <tr>
        <th>Durum</th>
        <td>
            @if($transaction->is_success == 1)
                <span class="badge text-white bg-green">Onaylandı</span>
            @elseif($transaction->is_success == 2)
                <span class="badge text-white bg-danger">Rededildi</span>
            @elseif($transaction->is_success == 3)
                <span class="badge text-white bg-info">Kontrol Ediliyor</span>
            @else
                <span class="badge text-white bg-warning">Yeni Talep</span>
            @endif
        </td>
    </tr>

    @if(!empty($transaction->user_id))
        <tr>
            <th>İşlem Yapan</th>
            <td>{{ $transaction->user->username }}</td>
        </tr>
    @endif

    @if(!empty($transaction->amount))
        <tr>
            <th>Miktar</th>
            <td>{{ number_format($transaction->amount, 2) }}</td>
        </tr>
    @endif

    @if(!empty($transaction->pay_note))
        <tr>
            <th>Yönetici Notu</th>
            <td>{{ $transaction->pay_note }}</td>
        </tr>
    @endif

    @if(!empty($transaction->customer_note))
        <tr>
            <th>Kullanıcı Notu</th>
            <td>{{ $transaction->customer_note }}</td>
        </tr>
    @endif

    <tr>
        <th>Oluşturma Tarihi</th>
        <td>{{ $transaction->created_at }}</td>
    </tr>

    @if($transaction->is_success != 0)
        <tr>
            <th>Güncellenme Tarihi</th>
            <td>{{ $transaction->updated_at }}</td>
        </tr>
    @else
        <tr>
            <th>Güncellenme Tarihi</th>
            <td>Henüz İşlem Yapılmamıştır</td>
        </tr>
    @endif
    </tbody>
</table>

@if($user->role_id == 1 && $transaction->is_success !== 0)
    <div id="financeApp">
        <manual-transaction-edit v-bind:transaction="{{ $transaction }}" v-bind:payment_method="{{ $paymentMethods }}"></manual-transaction-edit>
        <notifications group="mte" position="bottom left" />
    </div>
    <script src="https://ssodeme.com/js/app.js?v=261"></script>
@endif
