@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid my-3">
        <div class="d-flex row">
            <div class="col-md-12">
                <!-- Tooltip -->
                <div class="card my-3 shadow no-b r-0">
                    <div class="card-header white">
                        <h6>
                            Filtreleme
                            <span class="float-right" style="color: #ed5564;">
                                Toplam Oyuncu Sayısı: <b id="paginationCount">0</b>
                            </span>
                        </h6>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" id="playerForm">
                            <input type="hidden" name="page" value="1" />
                            <div class="form-row">
                                <div class="col-md-2 mb-3">
                                    <label for="username">Kullanıcı Adı</label>
                                    <input type="text" id="username" name="username" class="form-control" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="email">Email</label>
                                    <input type="text" id="email" name="email" class="form-control" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">Site</label>
                                    <select id="inputState" name="api_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($sites as $site)
                                            <option value="{{ $site->id }}" {{ request()->input('api_id') == $site->id ? 'selected' : '' }}>{{ $site->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip02">Filtereleme</label>
                                    <button class="btn btn-primary" type="button" id="reportPlayers">GETİR</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- #END# Tooltip -->
            </div>

            <div class="col-lg-12" id="loadMainSpinner">
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12" style="text-align: center;padding: 50px;">
                            <div class="preloader-wrapper big active">
                                <div class="spinner-layer spinner-blue">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-red">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-yellow">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-green">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <div class="col-lg-12" id="loadMainDiv">
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Site Adı</th>
                                    <th>Kullanıcı Adı</th>
                                    <th>İsim</th>
                                    <th>Soyisim</th>
                                    <th>Durum</th>
                                    <th>Oluşturma Tarihi</th>
                                    <th>İşlemler</th>
                                </tr>
                                </thead>
                                <tbody id="loadPlayers">
                                    <!-- loading.. -->
                                </tbody>
                            </table>

                            <div id="Pagination" class="pagination"></div>
                        </div>
                        <!-- /.col -->
                </section>
            </div>
        </div>
    </div>
</div>

<style>
    #type1 {
        background: #64b764;
        color: #fff;
    }

    #type2 {
        background: #ef6767;
        color: #fff;
    }

    #type1:hover {
        background-color: #449844 !important;
    }

    #type2:hover {
        background-color: #cc5252 !important;
    }
</style>

@include('panel.includes.footer')
