@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="row" style="margin: 20px 0 20px;">
            @if($user->role_id == 1)
            <div class="col-lg-10">
            </div>

            <div class="col-lg-2 text-right">
                <a href="{{ url('/admin/account-management/deposit-range/create') }}" class="btn btn-warning btn-lg btn-block">Yeni Kayıt Oluştur</a>
            </div>
            @endif
        </div>

        <section class="paper-card">
            <div class="row">
                <div class="col-lg-12">
                    <table id="example2" class="table table-bordered table-hover data-tables" data-page-length="25" data-order="[[ 0, &quot;desc&quot; ]]">
                        <thead>
                        <tr>
                            <th style="width: 10px">#</th>
                            <th>İsim</th>
                            <th>Min</th>
                            <th>Max</th>
                            <th>Durum</th>
                            <th>Güncelleme Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($depositRange as $dr)
                            <tr>
                                <td>{{ $dr->id }}</td>
                                <td>{{ $dr->name }}</td>
                                <td>{{ $dr->min }}</td>
                                <td>{{ $dr->max }}</td>
                                <td>
                                    @if($dr->status)
                                        <span class="badge text-white bg-green">Aktif</span>
                                    @else
                                        <span class="badge text-white bg-red">Pasif</span>
                                    @endif
                                </td>
                                <td>{{ $dr->updated_at }}</td>
                                <td>
                                    <a href="{{ url('/admin/account-management/deposit-range/edit/' . $dr->id) }}">
                                        <i class="icon-pencil"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.col -->
        </section>
    </div>
</div>

@include('panel.includes.footer')
