@if(count($cronJobs) > 0)
    @foreach($cronJobs as $cronJob)
        <tr>
            <td class="text-center">{{ $cronJob->id }}</td>
            <td class="text-center">
                @if($cronJob->user_id !== 0)
                    <a href="/admin/operators/edit/{{ $cronJob->user_id }}">
                        {{ $cronJob->user->username ?? '-' }}
                    </a>
                @else
                    -
                @endif
            </td>
            <td class="text-center">
                @if($cronJob->type_id === 1)
                    Saatlik
                @elseif($cronJob->type_id === 2 || $cronJob->type_id === 3 || $cronJob->type_id === 4)
                    Dakikalık
                @else
                    -
                @endif
            </td>
            <td class="text-center">{{ \App\CronJob::getType($cronJob->type_id) }}</td>
            <td class="text-center">{{ $cronJob->created_at }}</td>
            <td class="text-center">{{ $cronJob->updated_at }}</td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="6">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '{{ $cronJobs->total() }}',
        perPage: '{{ $cronJobs->perPage() }}',
        currentPage: '{{ $cronJobs->currentPage() }}',
    };
</script>
