<?php

namespace App\Http\Middleware;

use App\IpLog;
use App\User;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;

class CheckGoogleAuthenticator
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (auth()->check()) {
            $user = auth()->user();

            if ($user->ga_status == 1 && $user->ga_login == 0 && $request->segment(2) != 'ga_login') {
                return redirect('/admin/ga_login');
            }

            IpLog::addLog($user->id, $request->path());

            $checkUser = User::query()->where('id', $user->id)->where('status', 1)->count();

            if (!$checkUser) {
                auth()->logout();
            }

            if ($user->ip_address != getIpAddress() && $user->ga_status == 1 && $user->ga_login == 1) {
                User::query()
                    ->where('id', $user->id)
                    ->update([
                        'ip_address' => null,
                        'updated_at' => Carbon::now()
                    ]);

                auth()->logout();

                return redirect('/admin/login');
            }
        } else {
            $checkUser = User::query()->where('id', 0)->where('status', 1)->count();

            if (!$checkUser) {
                auth()->logout();
            }

            IpLog::addLog(0, $request->path());
        }

        return $next($request);
    }
}
