<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SandBoxController extends Controller
{
    public function depositIndex(Request $request)
    {
        $hash = $request->input('hash');

        $getTransaction = Transaction::where('hash', $hash)->first();

        return view('sandbox.deposit')
            ->with('transaction', $getTransaction);
    }

    public function withdrawIndex(Request $request)
    {
        $hash = $request->input('hash');

        $getTransaction = Transaction::where('hash', $hash)->first();

        return view('sandbox.withdraw')
            ->with('transaction', $getTransaction);
    }

    public function depositCallBack(Request $request)
    {
        $hash = $request->input('hash');
        $isSuccess = $request->input('is_success');
        $getTransaction = Transaction::where('hash', $hash)->first();
        $site = $getTransaction->sites;
        $amount = number_format(rand(500, 9999), 2, '.', '');

        if ($getTransaction->is_success == 0) {
            $parameters = [
                'apiId' => $site->id,
                'apiKey' => $site->code,
                'paymentId' => $getTransaction->id,
                'externalTransactionId' => $getTransaction->external_transaction_id,
                'userId' => $getTransaction->player->external_user_id,
                'username' => $getTransaction->player->username,
                'type' => 'deposit',
                'amount' => $amount,
                'status' => $isSuccess == 1 ? true : false,
                'message' => 'success',
                'hash' => $getTransaction->hash
            ];
            $postData = SeamlessController::postData($site->seamless_url, $parameters);

            # Hash Calculate
            $hashParameters = [
                'api_id' => $site->id,
                'api_key' => $site->code,
                'user_id' => $getTransaction->player->external_user_id,
                'username' => $getTransaction->player->username,
                'amount' => $amount,
                'type' => 'deposit'
            ];

            if (!empty($getTransaction->external_transaction_id))
                $hashParameters['external_transaction_id'] = $getTransaction->external_transaction_id;

            $generateHash = hash("sha512", http_build_query($hashParameters));

            if (!empty($postData['response']->status) && $postData['response']->status == 200) {
                if (!empty($postData['response']->hash) && $postData['response']->hash == $generateHash) {
                    $paymentMessage = 'Payment has been completed.';

                    Transaction::where('id', $getTransaction->id)->update([
                        'is_success' => $isSuccess,
                        'pay_note' => 'sandbox',
                        'amount' => $amount
                    ]);

                    echo '<script>setTimeout(function(){ window.location.reload(); }, 2000);</script>';
                } else {
                    $paymentMessage = 'Invalid hash made as response parameter.';
                }
            } else if (!empty($postData['response']->status) && $postData['response']->status == 201) {
                if (!empty($postData['response']->hash) && $postData['response']->hash == $generateHash) {
                    $paymentMessage = 'Payment has already been done.';

                    if ($getTransaction->is_success == 0) {
                        Transaction::where('id', $getTransaction->id)->update([
                            'is_success' => $isSuccess,
                            'pay_note' => 'sandbox',
                            'amount' => $amount
                        ]);
                    }
                } else {
                    $paymentMessage = 'Invalid hash made as response parameter.';
                }
            } else {
                $paymentMessage = 'An error has been raised when trying to send the request to the server.';
            }
        } else {
            $paymentMessage = 'Payment has already been done.';
            $postData = [
                'response' => json_decode(json_encode([])),
                'time' => 0,
                'url' => $site->seamless_url
            ];
        }

        echo '<div class="card-deck mb-3 text-center">
                <div class="card mb-4 box-shadow">
                    <div class="card-header">
                        <h4 class="my-0 font-weight-normal">Post-Payment Page</h4>
                    </div>
                    <div class="card-body">
                        <h1 class="card-title pricing-card-title">
                            ' . $paymentMessage . '
                        </h1>
                        
                        <pre style="text-align: left;"><code>' . (string)json_encode($postData['response'], JSON_PRETTY_PRINT) . '</code></pre>
                        
                        <footer class="blockquote-footer">' . $site->seamless_url . ' (' . $postData['time'] . ')</footer>
                    </div>
                </div>
            </div>';
    }

    public function withdrawCallBack(Request $request)
    {
        $hash = $request->input('hash');
        $isSuccess = $request->input('is_success');
        $getTransaction = Transaction::where('hash', $hash)->first();
        $site = $getTransaction->sites;
        $amount = number_format(rand(500, 9999), 2, '.', '');

        if ($getTransaction->is_success == 0) {
            $parameters = [
                'apiId' => $site->id,
                'apiKey' => $site->code,
                'paymentId' => $getTransaction->id,
                'externalTransactionId' => $getTransaction->external_transaction_id,
                'userId' => $getTransaction->player->external_user_id,
                'username' => $getTransaction->player->username,
                'type' => 'withdraw',
                'amount' => $amount,
                'status' => $isSuccess == 1 ? true : false,
                'message' => 'success',
                'hash' => $getTransaction->hash
            ];
            $postData = SeamlessController::postData($site->seamless_url, $parameters);

            # Hash Calculate
            $hashParameters = [
                'api_id' => $site->id,
                'api_key' => $site->code,
                'user_id' => $getTransaction->player->external_user_id,
                'username' => $getTransaction->player->username,
                'amount' => $amount,
                'type' => 'withdraw'
            ];

            if (!empty($getTransaction->external_transaction_id))
                $hashParameters['external_transaction_id'] = $getTransaction->external_transaction_id;

            $generateHash = hash("sha512", http_build_query($hashParameters));

            if (!empty($postData['response']->status) && $postData['response']->status == 200) {
                if (!empty($postData['response']->hash) && $postData['response']->hash == $generateHash) {
                    $paymentMessage = 'Payment has been completed.';

                    Transaction::where('id', $getTransaction->id)->update([
                        'is_success' => $isSuccess,
                        'pay_note' => 'sandbox',
                        'amount' => $amount
                    ]);

                    echo '<script>setTimeout(function(){ window.location.reload(); }, 2000);</script>';
                } else {
                    $paymentMessage = 'Invalid hash made as response parameter.';
                }
            } else if (!empty($postData['response']->status) && $postData['response']->status == 201) {
                if (!empty($postData['response']->hash) && $postData['response']->hash == $generateHash) {
                    $paymentMessage = 'Payment has already been done.';

                    if ($getTransaction->is_success == 0) {
                        Transaction::where('id', $getTransaction->id)->update([
                            'is_success' => $isSuccess,
                            'pay_note' => 'sandbox',
                            'amount' => $amount
                        ]);
                    }
                } else {
                    $paymentMessage = 'Invalid hash made as response parameter.';
                }
            } else {
                $paymentMessage = 'An error has been raised when trying to send the request to the server.';
            }
        } else {
            $paymentMessage = 'Payment has already been done.';
            $postData = [
                'response' => json_decode(json_encode([])),
                'time' => 0,
                'url' => $site->seamless_url
            ];
        }

        echo '<div class="card-deck mb-3 text-center">
                <div class="card mb-4 box-shadow">
                    <div class="card-header">
                        <h4 class="my-0 font-weight-normal">Post-Payment Page</h4>
                    </div>
                    <div class="card-body">
                        <h1 class="card-title pricing-card-title">
                            ' . $paymentMessage . '
                        </h1>
                        
                        <pre style="text-align: left;"><code>' . (string)json_encode($postData['response'], JSON_PRETTY_PRINT) . '</code></pre>
                        
                        <footer class="blockquote-footer">' . $site->seamless_url . ' (' . $postData['time'] . ')</footer>
                    </div>
                </div>
            </div>';
    }
}
