<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class GizaBetController extends Controller
{
    private static $depositUrl = 'https://mani.pronetgaming.eu/paymentapi/deposit';
    private static $drawUrl = 'https://mani.pronetgaming.eu/paymentapi/directWithdraw';
    private static $traderId = 124;
    private static $channelId = 118;
    private static $username = 'BPAPARAGIZA';
    private static $password = '3fKda10rlM';
    private static $apiId = 3;
    private static $apiKey = 'r6A9nPsNDCJS7avLKg5CqBCkWDsfS0sC';

    public static function getProNetCallBack(Request $request)
    {
        if ($request->input('type') == 'deposit') {
            if ($request->input('status') == true) {
                $requestArray = [
                    "channelId" => self::$channelId,
                    "apiUsername" => self::$username,
                    "traderId" => self::$traderId,
                    "customerCode" => $request->input('userId'),
                    "channelTransactionId" => Str::random(20),
                    "amount" => $request->input('amount'),
                    "currencyCode" => "TRY",
                    "accountMasterTypeCode" => "873",
                    //"remark" => "Deposit request remark",
                ];

                $requestArray['checksum'] = self::checksumCalculate($requestArray);

                $json = self::postRequest(self::$depositUrl, $requestArray);
            } else {
                $json = [
                    'response' => json_decode(json_encode([
                        'resultCode' => 0,
                        'noSend' => true
                    ])),
                    'time' => 0,
                    'url' => ''
                ];
            }
        } else {
            $requestArray = [
                "channelId" => self::$channelId,
                "apiUsername" => self::$username,
                "traderId" => self::$traderId,
                "customerCode" => $request->input('userId'),
                "channelTransactionId" => Str::random(20),
                "amount" => $request->input('amount'),
                "currencyCode" => "TRY",
                "accountMasterTypeCode" => "974",
                //"remark" => "Deposit request remark",
            ];

            $requestArray['checksum'] = self::checksumCalculate($requestArray);

            $json = self::postRequest(self::$drawUrl, $requestArray);
        }

        if ($json['response']->resultCode == 0) {
            if (empty($json['response']->noSend)) {
                $username = $json['response']->customerUsername;
                $firstName = $json['response']->firstName;
                $lastName = $json['response']->lastName;
                $newBalance = $json['response']->newBalance;
                $currencyCode = $json['response']->currencyCode;

                Player::where('api_id', self::$apiId)
                    ->where('external_user_id', $request->input('userId'))
                    ->update([
                        'first_name' => $firstName,
                        'last_name' => $lastName,
                        'username' => $username,
                        'updated_at' => Carbon::now()
                    ]);
            }

            return response()->json([
                "status" => 200,
                "message" => "success",
                "hash" => self::calculateHash(
                    $request->input('userId'),
                    $request->input('username'),
                    $request->input('amount'),
                    $request->input('type'),
                    $request->input('externalTransactionId')
                )
            ]);
        } else if ($json['response']->resultCode == 16) {
            return response()->json([
                "status" => 201,
                "message" => "transaction already",
                "hash" => self::calculateHash(
                    $request->input('userId'),
                    $request->input('username'),
                    $request->input('amount'),
                    $request->input('type'),
                    $request->input('externalTransactionId')
                )
            ]);
        } else {
            return response()->json([
                "status" => 404,
                "message" => !empty($json['response']->resultMessage) ?
                    $json['response']->resultMessage :
                    (!empty($json['response']->responseMessage) ? $json['response']->responseMessage : 'transaction not found'),
                "hash" => self::calculateHash(
                    $request->input('userId'),
                    $request->input('username'),
                    $request->input('amount'),
                    $request->input('type'),
                    $request->input('externalTransactionId')
                )
            ]);
        }
    }

    /**
     * @param $url
     * @param array $requestArray
     * @return array
     */
    private static function postRequest($url, $requestArray = [])
    {
        $fields_string = json_encode($requestArray);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type:application/json']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        $response = curl_exec($ch);

        $info = curl_getinfo($ch);

        curl_close($ch);

        #echo '<pre>'; print_r($response); die;

        $json = json_decode($response);

        return [
            'response' => $json,
            'time' => $info['total_time'],
            'url' => $info['url']
        ];
    }

    /**
     * @param array $data
     * @return string
     */
    private static function checksumCalculate($data = [])
    {
        ksort($data);

        $string = self::checksumString(
            http_build_query($data) . self::$password
        );

        return md5($string);
    }

    /**
     * @param $string
     * @return mixed
     */
    private static function checksumString($string)
    {
        $string = str_replace('&', '', $string);
        $string = str_replace('=', '', $string);

        return $string;
    }

    /**
     * @param $userId
     * @param $username
     * @param $amount
     * @param string $type
     * @param null $externalTransactionId
     * @return string
     */
    private static function calculateHash(
        $userId,
        $username,
        $amount,
        $type = 'deposit',
        $externalTransactionId = null
    )
    {
        $parameters = [
            'api_id' => self::$apiId,
            'api_key' => self::$apiKey,
            'user_id' => $userId,
            'username' => $username,
            'amount' => $amount,
            'type' => $type
        ];

        if (!empty($externalTransactionId))
            $parameters['external_transaction_id'] = $externalTransactionId;

        $generateHash = hash("sha512", http_build_query($parameters));

        return $generateHash;
    }
}
