<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\DepositRange;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use App\WhiteListIp;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Faker\Factory as Faker;

class DemoController extends Controller
{
    public function index($theme = null)
    {
        if (!empty(env('DEMO_API'))) {
            $getApiDetail = Site::where('id', env('DEMO_API'))->first();

            if (empty($getApiDetail)) {
                $getApiDetail = [];
            }
        } else {
            $getApiDetail = [];
        }

        return view('demo.index')
            ->with('api', $getApiDetail);
    }

    public function store(Request $request)
    {
        $paymentMethod = $request->input('payment_method');
        $type = $request->input('type');
        $firstName = $request->input('first_name');
        $lastName = $request->input('last_name');
        $customerNote = $request->input('customer_note');
        $amount = $request->input('amount');
        $apiId = env('DEMO_API');

        if (
            empty($paymentMethod) ||
            empty($type) ||
            empty($firstName) ||
            empty($lastName)
        )
            return response()->json([
                'status' => false,
                'message' => 'Hata, lütfen boş alan bırakmayınız !'
            ]);

        if ($type == 2 && empty($amount))
            return response()->json([
                'status' => false,
                'message' => 'Hata, lütfen miktar giriniz !'
            ]);

        if (empty($apiId))
            return response()->json([
                'status' => false,
                'message' => 'Lütfen, Panel üzerinden demo site tanımlaması yapınız !'
            ]);

        $checkApi = Site::where('id', $apiId)->first();

        if (empty($checkApi))
            return response()->json([
                'status' => false,
                'message' => 'Hata, demo site bulunamamıştır !'
            ]);

        if ($checkApi->status != 1)
            return response()->json([
                'status' => false,
                'message' => 'Hata, demo site aktif değildir !'
            ]);

        $faker = Faker::create();

        $sendData = [
            'api_id' => $checkApi->id,
            'api_key' => $checkApi->code,
            'user_id' => rand(100000, 9999999999),
            'external_transaction_id' => $faker->uuid,
            'username' => $faker->userName,
            'first_name' => $firstName,
            'last_name' => $lastName,
            'lang' => 'tr',
            'currency' => 'TRY',
            'return_url_success' => $checkApi->return_url,
            'return_url_fail' => $checkApi->return_url_fail
        ];

        if ($paymentMethod == 1 || $paymentMethod == 2 || $paymentMethod == 3) {
            $method = 'papara';
        } else {
            $method = 'bank-transfer';
        }

        if ($type == 1) {
            $typeName = 'deposit';
        } else {
            $typeName = 'draw';
        }

        if ($method == 'papara' && $type == 2) {
            $sendData['amount'] = $amount;
            $sendData['account_number'] = $faker->bankAccountNumber;
        }

        if ($method == 'bank-transfer' && $type == 2) {
            $sendData['amount'] = $amount;
            $sendData['account_number'] = $faker->bankAccountNumber;
            $sendData['iban'] = $faker->iban('TR');
            $sendData['bank_id'] = 6;
            $sendData['branch_code'] = 12345;
        }

        $post = SeamlessController::postData(url('/payment/' . $typeName . '/' . $method, [], true), $sendData);

        if (!empty($post['response']) && $post['response']->code == 200) {

            switch ($paymentMethod) {
                case 1:
                    $bankTransferType = 2;
                    $paparaType = 3;
                    break;

                case 2:
                    $bankTransferType = 2;
                    $paparaType = 1;
                    break;

                case 3:
                    $bankTransferType = 2;
                    $paparaType = 2;
                    break;

                case 4:
                    $bankTransferType = 1;
                    $paparaType = 3;
                    break;

                case 5:
                    $bankTransferType = 2;
                    $paparaType = 3;
                    break;

                default:
                    $bankTransferType = 2;
                    $paparaType = 3;
                    break;
            }

            $path = base_path('.env');

            if (file_exists($path)) {
                file_put_contents($path, str_replace(
                    'PAPARA_TYPE=' . env('PAPARA_TYPE'), 'PAPARA_TYPE=' . $paparaType, file_get_contents($path)
                ));
                file_put_contents($path, str_replace(
                    'BANK_TRANSFER_TYPE=' . env('BANK_TRANSFER_TYPE'), 'BANK_TRANSFER_TYPE=' . $bankTransferType, file_get_contents($path)
                ));
            }

            return response()->json([
                'status' => true,
                'message' => $post['response']->message,
                'url' => $post['response']->url
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => $post['response']->message,
                'data' => $post['response']
            ]);
        }
    }
}
