<?php

if (!function_exists('sxConvertName')) {
    function sxConvertName($str): string
    {
        $turkishCharacters = ['ç', 'Ç', 'ğ', 'Ğ', 'ı', 'İ', 'ö', 'Ö', 'ş', 'Ş', 'ü', 'Ü'];
        $englishCharacters = ['c', 'C', 'g', 'G', 'i', 'I', 'o', 'O', 's', 'S', 'u', 'U'];

        $str = str_replace($turkishCharacters, $englishCharacters, $str);
        $str = preg_replace('/[^A-Za-z0-9\-]/', '-', $str);

        return strtolower($str);
    }
}

if (!function_exists('sxCreateHiddenName')) {
    function sxCreateHiddenName($str): string
    {
        $str = explode(' ', trim($str));
        $responseString = '';

        foreach ($str as $value) {
            $responseString .= mb_substr(turkishStrToUpper($value), 0, 1, 'utf8') . '*** ';
        }

        return strtoupper(trim($responseString));
    }
}

if (!function_exists('sxCreateFirstAndLastName')) {
    function sxCreateFirstAndLastName($str): string
    {
        $explodeString = explode(' ', trim($str));
        $countString = count($explodeString);
        $newString = trim($explodeString[0]) . ' ' . trim($explodeString[$countString - 1]);
        return strtoupper(trim(turkishStrToUpper($newString)));
    }
}

if (!function_exists('sxCountName')) {
    function sxCountName($str): int
    {
        if (empty($str)) return 0;
        $explodeString = explode(' ', trim($str));
        return count($explodeString);
    }
}

if (!function_exists('turkishStrToUpper')) {
    function turkishStrToUpper($str): string
    {
        $turkishCharacters = ['ç', 'Ç', 'ğ', 'Ğ', 'ı', 'İ', 'i', 'ö', 'Ö', 'ş', 'Ş', 'ü', 'Ü'];
        $englishCharacters = ['Ç', 'Ç', 'Ğ', 'Ğ', 'I', 'İ', 'İ', 'Ö', 'Ö', 'Ş', 'Ş', 'Ü', 'Ü'];

        $str = str_replace($turkishCharacters, $englishCharacters, $str);

        return trim($str);
    }
}

if (!function_exists('runCronJob')) {
    function runCronJob($typeId, $params)
    {
        switch ($typeId) {
            case 1:
                $url = '/cron/hourly/delete-empty-transactions?';
                break;

            case 2:
                $url = '/cron/minutely/sx-match-bank-ids?';
                break;

            case 3:
                $url = '/cron/minutely/sx-match-transaction-ids?';
                break;

            case 4:
                $url = '/cron/minutely/sx-check-vault-transfer?';
                break;

            case 5:
                $url = '/cron/minutely/sx-run-callback?';
                break;

            default:
                $url = null;
                break;
        }

        if ($url === null)
            return false;

        if (!empty($params)) {
            $params = http_build_query($params);
        } else {
            $params = '';
        }

        $url = env('APP_URL') . $url . $params;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }
}

if (!function_exists('hashCalculate')) {
    /**
     * @param $apiId
     * @param $apiKey
     * @param $userId
     * @param $username
     * @param $amount
     * @param $type
     * @param $externalTransactionId
     * @return string
     */
    function hashCalculate(
        $apiId,
        $apiKey,
        $userId,
        $username,
        $amount,
        $type,
        $externalTransactionId
    ): string
    {
        $hashParameters = [
            'api_id' => $apiId,
            'api_key' => $apiKey,
            'user_id' => $userId,
            'username' => $username,
            'amount' => $amount,
            'type' => $type
        ];

        if (!empty($externalTransactionId))
            $hashParameters['external_transaction_id'] = $externalTransactionId;

        $generateHash = hash("sha512", http_build_query($hashParameters));

        return trim($generateHash);
    }
}

if (!function_exists('checkHash')) {
    /**
     * @param $responseHash
     * @param $generateHash
     * @return bool
     */
    function checkHash($responseHash, $generateHash): bool
    {
        if (!empty($responseHash) && $responseHash == $generateHash)
            return true;
        else
            return false;
    }
}

if (!function_exists('checkAccountSite')) {
    /**
     * @param $apiId
     * @param $query
     * @return mixed
     */
    function checkAccountSite($apiId, $query)
    {
        foreach ($query as $key => $q) {
            /*if (!empty($q->api_id)) {
                $explodeApiId = explode(',', $q->api_id);

                if (!in_array($apiId, $explodeApiId)) {
                    unset($query[$key]);
                }
            }*/
            if (empty($q->api_id)) continue;
            $explodeApiId = explode(',', $q->api_id);

            if (!in_array($apiId, $explodeApiId)) {
                unset($query[$key]);
            }
        }

        return $query;
    }
}

if (!function_exists('getIpAddress')) {
    function getIpAddress()
    {
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } else if (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
            if (strstr($ip, ',')) {
                $tmp = explode (',', $ip);
                $ip = trim($tmp[0]);
            }
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        return $ip;
    }
}

if (!function_exists('getTransactionStatusName')) {
    function getTransactionStatusName($status): string
    {
        switch ($status) {
            case 1:
                return 'Onaylandı';
            case 2:
                return 'Rededildi';
            case 3:
                return 'Kontrol Ediliyor';
            default:
                return 'Yeni Talep';
        }
    }
}

if (!function_exists('dayDifferenceCalculation')) {
    function dayDifferenceCalculation($d1, $d2): string
    {
        $date1 = new DateTime($d1);
        $date2 = new DateTime($d2);

        return (int)$date2->diff($date1)->format("%a");
    }
}

if (!function_exists('playerQueryExplode')) {
    function playerQueryExplode($q): array
    {
        $queryExplode = explode(' ', trim($q));
        $countExplode = count($queryExplode);

        $firstNameStr = '';
        if ($countExplode > 2) {
            foreach($queryExplode as $k => $v) {
                if ($k < $countExplode) {
                    $firstNameStr .= $v . ' ';
                }
            }
        }

        if ($countExplode == 1) {
            return [
                'length' => 1,
                'first_name' =>  trim($queryExplode[0]),
                'last_name' =>  ''
            ];
        } else if ($countExplode == 2) {
            return [
                'length' => 2,
                'first_name' =>  trim($queryExplode[0]),
                'last_name' =>  trim($queryExplode[($countExplode - 1)])
            ];
        } else {
            return [
                'length' => $countExplode,
                'first_name' =>  trim($firstNameStr),
                'last_name' =>  trim($queryExplode[1])
            ];
        }
    }
}
