<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BankAccount extends Model
{
    protected $table = 'bank_accounts';

    /**
     * @param $typeId
     * @return string
     */
    public static function getType($typeId)
    {
        switch ($typeId) {
            case 1:
                return 'Havale/EFT';
                break;

            case 2:
                return 'PaPara';
                break;

            case 3:
                return 'CMT Cüzdan';
                break;

            case 4:
                return 'PepPara';
                break;

            case 5:
                return 'Param Havale';
                break;

            case 6:
                return 'Param Card';
                break;

            default:
                return 'Bilinmiyor';
                break;
        }
    }

    /**
     * @param $serverId
     * @return string
     */
    public static function getMailServer($serverId)
    {
        switch ($serverId) {
            case 1:
                return '{imap.yandex.com:993/imap/ssl}INBOX';
                break;

            case 2:
                return '{imap.gmail.com:993/imap/ssl}INBOX';
                break;

            default:
                return null;
                break;
        }
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function banks()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function deposit_range()
    {
        return $this->belongsTo(DepositRange::class, 'deposit_range_id');
    }

    /**
     * @param $bankAccountId
     * @param $amount
     * @return int
     */
    public static function addBankBalance($bankAccountId, $amount): int
    {
        return self::query()
            ->where('id', (int)$bankAccountId)
            ->update([
                'balance' => DB::raw('balance + ' . $amount)
            ]);
    }

    /**
     * @param $bankAccountId
     * @param $amount
     * @return int
     */
    public static function removeBankBalance($bankAccountId, $amount): int
    {
        return BankAccount::query()
            ->where('id', (int)$bankAccountId)
            ->update([
                'balance' => DB::raw('balance - ' . $amount)
            ]);
    }
}
