<?php if(count($apiLogs) > 0): ?>
    <?php $__currentLoopData = $apiLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            if ($log->type_id === 2) {
                $responseContent = json_decode($log->response_content);

                if (!empty($responseContent) && (int)$responseContent->status === 200) {
                    $responseError = false;
                } else {
                    $responseError = true;
                }
            } else {
                $responseContent = json_decode($log->response_content);

                if (!empty($responseContent) && (int)$responseContent->code === 200) {
                    $responseError = false;
                } else {
                    $responseError = true;
                }
            }
        ?>
        <tr class="<?php echo e($responseError === true ? 'errorApiBg' : ''); ?>">
            <td class="text-center">
                <?php if($log->user_id !== 0): ?>
                    <a href="/admin/operators/edit/<?php echo e($log->user_id); ?>">
                        <?php echo e($log->user->username ?? '-'); ?>

                    </a>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
            <td class="text-center">
                <?php if($log->type_id === 1): ?>
                    API
                <?php elseif($log->type_id === 2): ?>
                    Seamless
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
            <td class="text-center"><?php echo e($log->transaction_id); ?></td>
            <td class="text-center">
                <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#requestModal_<?php echo e($log->id); ?>">
                    İçeriği Gör
                </button>

                <!-- Modal -->
                <div class="modal fade" id="requestModal_<?php echo e($log->id); ?>" tabindex="-1" aria-labelledby="requestModal_<?php echo e($log->id); ?>_Label" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">#<?php echo e($log->id); ?> İçeriğine Ait Request JSON</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <pre class="brush: json text-left"><?php echo e(json_encode(json_decode($log->request_content), JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#responseModal_<?php echo e($log->id); ?>">
                    İçeriği Gör
                </button>

                <!-- Modal -->
                <div class="modal fade" id="responseModal_<?php echo e($log->id); ?>" tabindex="-1" aria-labelledby="responseModal_<?php echo e($log->id); ?>_Label" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">#<?php echo e($log->id); ?> İçeriğine Ait Response JSON</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <pre class="brush: json text-left"><?php echo e(json_encode(json_decode($log->response_content), JSON_PRETTY_PRINT)); ?></pre>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
            <td class="text-center"><?php echo e($log->elapsed_time); ?></td>
            <td class="text-center"><?php echo e($log->created_at); ?></td>
            <td class="text-center"><?php echo e($log->updated_at); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <tr>
        <td colspan="8">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
<?php endif; ?>

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '<?php echo e($apiLogs->total()); ?>',
        perPage: '<?php echo e($apiLogs->perPage()); ?>',
        currentPage: '<?php echo e($apiLogs->currentPage()); ?>',
    };
</script>

<style>
    .errorApiBg {
        background-color: darkred;
        color: #fff;
    }

    .errorApiBg:hover {
        background-color: darkred !important;
        color: #fff !important;
    }

    .errorApiBg a {
        text-decoration: none;
        color: #fff;
    }
</style>
<?php /**PATH /home/bpaparac/public_html/resources/views/panel/api_log_list.blade.php ENDPATH**/ ?>