@if(count($transactions) > 0)
    @foreach($transactions as $transaction)
        <tr style="cursor: pointer" process-id="{{ $transaction->id }}" class="detailTransaction">
            <td>{{ $transaction->id }}</td>
            <td>{{ $transaction->sites->name }}</td>
            <td id="type{{ $transaction->payment_method->type }}">{{ \App\PaymentMethod::getType($transaction->payment_method->type) }}</td>
            <td>
              <a href="/admin/players/show/{{ $transaction->player_id }}">
                @if($transaction->sites->platform === 3 || $transaction->sites->platform === 2)
                  {{ $transaction->player->external_user_id }}
                @else
                  {{ $transaction->player->username }}
                @endif
                ({{ $transaction->player->first_name . ' '. $transaction->player->last_name }})
              </a>
            </td>
            <td>{{ $transaction->payment_method->name }}</td>
            <td>{{ number_format($transaction->amount, 2) }}</td>
            <td>
                @if($transaction->is_success == 1)
                    <span class="badge text-white bg-green">Onaylandı</span>
                @elseif($transaction->is_success == 2)
                    <span class="badge text-white bg-danger">Rededildi</span>
                @elseif($transaction->is_success == 3)
                    <span class="badge text-white bg-info">Kontrol Ediliyor</span>
                @else
                    <span class="badge text-white bg-warning">Yeni Talep</span>
                @endif
            </td>
            <td>{{ $transaction->updated_at }}</td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="8">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '{{ $transactions->total() }}',
        perPage: '{{ $transactions->perPage() }}',
        currentPage: '{{ $transactions->currentPage() }}',
    };
</script>
