@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid my-3">
        <div class="row">
            @if($message = Session::get('error'))
            <div class="col-md-12">
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">×</button>
                    <strong>{{ $message }}</strong>
                </div>
            </div>
            @endif

            <div class="col-md-4">
                <div class="card">
                    <div class="card-body b-b">
                        <form method="POST" action="">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">

                            <div class="form-group">
                                <label for="api_id" class="col-form-label">Site Adı</label>
                                <input type="text" class="form-control" id="api_id" value="{{ $detail->sites->name }}" disabled>
                            </div>

                            <div class="form-group">
                                <label for="username" class="col-form-label">Kullanıcı Adı</label>
                                <input type="text" class="form-control" id="username" value="{{ $detail->username }}" disabled>
                            </div>

                            <div class="form-group">
                                <label for="external_user_id" class="col-form-label">Dış Kullanıcı ID</label>
                                <input type="text" class="form-control" id="external_user_id" value="{{ $detail->external_user_id }}" disabled>
                            </div>

                            <div class="form-group">
                                <label for="email" class="col-form-label">Email</label>
                                <input type="text" class="form-control" id="email" name="email" value="{{ $detail->email }}">
                            </div>

                            <div class="form-group">
                                <label for="first_name" class="col-form-label">İsim</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" value="{{ $detail->first_name }}">
                            </div>

                            <div class="form-group">
                                <label for="last_name" class="col-form-label">Soyisim</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" value="{{ $detail->last_name }}">
                            </div>

                            @if($user->access_contact == 1)
                            <div class="form-group">
                                <label for="phone_number" class="col-form-label">Telefon Numarası</label>
                                <input type="text" class="form-control" id="phone_number" name="phone_number" value="{{ $detail->phone_number }}">
                            </div>
                            @endif
                            
                            <div class="form-group">
                                <label for="status" class="col-form-label">Durum</label>
                                <select id="status" name="status" class="form-control">
                                    <option value="1" {{ $detail->status == 1 ? 'selected' : '' }}>Aktif</option>
                                    <option value="0" {{ $detail->status == 0 ? 'selected' : '' }}>Pasif</option>
                                </select>
                            </div>

                            @if($user->role_id == 1)
                            <button type="submit" class="btn btn-primary">Güncelle</button>
                            @endif

                            <!--<div class="form-group">
                                <a href="https://joybet141.com/admin/customer/balance/id/{{ $detail->external_user_id }}" target="_blank" class="btn btn-success btn-lg btn-block">JOYBET PROFİLİ GÖR</a>
                            </div>-->
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <!-- Tooltip -->
                <div class="card my-3 shadow no-b r-0" style="margin-top: 2px !important;">
                    <div class="card-header white">
                        <h6>
                            Filtreleme
                        </h6>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" id="reportForm">
                            <input type="hidden" name="player_id" value="{{ $detail->id }}">

                            <div class="form-row">
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Başlangıç Tarihi</label>
                                    <input type="text" name="filter_start_date" class="date-time-picker form-control" data-options='{"format":"Y-m-d H:i"}' placeholder="Başlangıç Tarihi" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Bitiş Tarihi</label>
                                    <input type="text" name="filter_end_date" class="date-time-picker form-control" data-options='{"format":"Y-m-d H:i"}' placeholder="Bitiş Tarihi" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltipUsername">Ödeme Yöntemi</label>
                                    <select id="inputState" name="method_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($paymentMethods as $paymentMethod)
                                            <option value="{{ $paymentMethod->id }}" {{ request()->input('method_id') == $paymentMethod->id ? 'selected' : '' }}>[{{ $paymentMethod->type == 1 ? 'Yatırım' : 'Çekim' }}] {{ $paymentMethod->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Site</label>
                                    <select id="inputState" name="api_id" class="form-control">
                                        <option value="">Hepsi</option>
                                        @foreach($sites as $site)
                                            <option value="{{ $site->id }}" {{ request()->input('api_id') == $site->id ? 'selected' : '' }}>{{ $site->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip02">Filtereleme</label>
                                    <button class="btn btn-primary" type="button" id="reportFilter">GETİR</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- #END# Tooltip -->

                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12" id="loadMainSpinner">
                            <section class="paper-card">
                                <div class="row">
                                    <div class="col-lg-12" style="text-align: center;padding: 50px;">
                                        <div class="preloader-wrapper big active">
                                            <div class="spinner-layer spinner-blue">
                                                <div class="circle-clipper left">
                                                    <div class="circle"></div>
                                                </div><div class="gap-patch">
                                                    <div class="circle"></div>
                                                </div><div class="circle-clipper right">
                                                    <div class="circle"></div>
                                                </div>
                                            </div>

                                            <div class="spinner-layer spinner-red">
                                                <div class="circle-clipper left">
                                                    <div class="circle"></div>
                                                </div><div class="gap-patch">
                                                    <div class="circle"></div>
                                                </div><div class="circle-clipper right">
                                                    <div class="circle"></div>
                                                </div>
                                            </div>

                                            <div class="spinner-layer spinner-yellow">
                                                <div class="circle-clipper left">
                                                    <div class="circle"></div>
                                                </div><div class="gap-patch">
                                                    <div class="circle"></div>
                                                </div><div class="circle-clipper right">
                                                    <div class="circle"></div>
                                                </div>
                                            </div>

                                            <div class="spinner-layer spinner-green">
                                                <div class="circle-clipper left">
                                                    <div class="circle"></div>
                                                </div><div class="gap-patch">
                                                    <div class="circle"></div>
                                                </div><div class="circle-clipper right">
                                                    <div class="circle"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>

                        <div class="col-lg-12" id="loadMainDiv">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th>Site</th>
                                    <th>Ödeme Yöntemi</th>
                                    <th>Yatırım</th>
                                    <th>Adet</th>
                                    <th>Komisyon (%)</th>
                                    <th>Çekim</th>
                                    <th>Adet</th>
                                    <th>Komisyon (%)</th>
                                    <th>Kar/Zarar</th>
                                </tr>
                                </thead>
                                <tbody id="loadReports">
                                <!-- loading.. -->
                                </tbody>
                            </table>
                        </div>
                        <!-- /.col -->
                </section>
            </div>
        </div>
    </div>
</div>

@include('panel.includes.footer')
