@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid my-3">
        <div class="d-flex row">
            <div class="col-md-12">
                <!-- Tooltip -->
                <div class="card my-3 shadow no-b r-0">
                    <div class="card-header white">
                        <h6>
                            Filtreleme
                            <span class="float-right" style="color: #ed5564;">
                                Toplam Hesap Sayısı: <b id="paginationCount">0</b>
                            </span>
                        </h6>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" novalidate="" id="accountListForm">
                            <input type="hidden" name="page" value="1" />
                            <div class="form-row">
                                <div class="col-md-1 mb-3">
                                    <label for="type_id">Tip</label>
                                    <select id="type_id" name="type_id" class="form-control" onchange="accountList()">
                                        <option value="">Hepsi</option>
                                        <option value="1">Havale/EFT</option>
                                        <option value="2">PaPara</option>
                                        <option value="3">CMT Cüzdan</option>
                                        <option value="4">PepPara</option>
                                        <option value="5">Param Havale</option>
                                        <option value="6">Param Card</option>
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltipUsername">Durum</label>
                                    <select id="inputState" name="status" class="form-control" onchange="accountList()">
                                        <option value="1">Aktif</option>
                                        <option value="0">Pasif</option>
                                        <option value="2">Kullanım Dışı</option>
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip01">Hesap ID</label>
                                    <input type="text" name="process_id" class="form-control" placeholder="Örnek: 1024" onkeydown="if (event.keyCode == 13) accountList()" />
                                </div>
                                <div class="col-md-2 mb-3">
                                    <label for="validationTooltip01">Arama</label>
                                    <input type="text" name="q" class="form-control" placeholder="Örnek: Halil Cengiz" id="accountSearchText" />
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="bank_id">Banka</label>
                                    <select id="bank_id" name="bank_id" class="form-control" onchange="accountList()">
                                        <option value="">Hepsi</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}" {{ request()->input('bank_id') == $bank->id ? 'selected' : '' }}>{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="deposit_range_id">Yatırım Aralığı</label>
                                    <select id="deposit_range_id" name="deposit_range_id" class="form-control" onchange="accountList()">
                                        <option value="">Hepsi</option>
                                        @foreach($depositRange as $deposit_range)
                                            <option value="{{ $deposit_range->id }}" {{ request()->input('deposit_range_id') == $deposit_range->id ? 'selected' : '' }}>{{ $deposit_range->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1 mb-3">
                                    <label for="validationTooltip02">Filtereleme</label>
                                    <button class="btn btn-primary" type="button" id="accountListFilter">GETİR</button>
                                </div>
                                <div class="col-md-2 mb-3">
                                </div>
                                <div class="col-md-2 text-right">
                                    <label for="validationTooltip02">&nbsp;</label>
                                    <a href="{{ url('/admin/account-management/accounts/create') }}" class="btn btn-warning btn-lg btn-block">Yeni Kayıt Oluştur</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- #END# Tooltip -->
            </div>

            <div class="col-lg-12">
                <div class="errors" style="display: none;">
                    <!-- loading... -->
                </div>
            </div>

            <div class="col-lg-12" id="loadMainSpinner">
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12" style="text-align: center;padding: 50px;">
                            <div class="preloader-wrapper big active">
                                <div class="spinner-layer spinner-blue">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-red">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-yellow">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>

                                <div class="spinner-layer spinner-green">
                                    <div class="circle-clipper left">
                                        <div class="circle"></div>
                                    </div><div class="gap-patch">
                                        <div class="circle"></div>
                                    </div><div class="circle-clipper right">
                                        <div class="circle"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <div class="col-lg-12" id="loadMainDiv">
                <section class="paper-card">
                    <div class="row">
                        <div class="col-lg-12">
                            <table id="example2" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Site</th>
                                    <th>Tip</th>
                                    <th>Banka Adı</th>
                                    <th>PaPara IBAN?</th>
                                    <th>Hesap Sahibi</th>
                                    <th>Hesap Numarası</th>
                                    <!--<th>Şube Kodu</th>
                                    <th>IBAN</th>-->
                                    <th>Yatırım Adet</th>
                                    <th>Çekim Adet</th>
                                    <th>Bakiye</th>
                                    <th>Açıklama</th>
                                    <th>Yatırım Aralığı</th>
                                    <th>Durum</th>
                                    <th>Güncelleme Tarihi</th>
                                    <th>İşlemler</th>
                                </tr>
                                </thead>
                                <tbody id="loadAccountList">
                                    <!-- loading.. -->
                                </tbody>
                            </table>

                            <div id="Pagination" class="pagination"></div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>

<style>
    #type1 {
        background: #64b764;
        color: #fff;
    }

    #type2 {
        background: #ef6767;
        color: #fff;
    }

    #type1:hover {
        background-color: #449844 !important;
    }

    #type2:hover {
        background-color: #cc5252 !important;
    }
</style>

@include('panel.includes.footer')
