<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Jekyll v3.8.5">
    <title>Payment Page</title>
    <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/css/fontawesome.min.css" rel="stylesheet">
    <link href="/assets/css/app.css" rel="stylesheet">
</head>
<body>
    <div class="{{ request()->input('container') == 1 ? 'container' : '' }}">
        @if(empty($paymentMethod))
        <div class="panel-home">
            <div class="panel-content">
                <div class="payment-logo">
                    <img src="/assets/img/error.png">
                </div>
                <div class="payment-error-text">Böyle Bir Ödeme Sayfası ya da Ödeme Yöntemi Bulunamadı. Lütfen firmanız ile iletişime geçiniz.</div>
            </div>
        </div>
        @else

        <script>var bankAccounts = {!! json_encode($bankAccounts) !!};</script>
        <div class="panel-home" style="display: block">
            <div class="panel-content">
                <div class="money-check-desc">
                    <a class="depositBackBtn" href="/payment/lobby">
                        <i class="fas fa-arrow-left"></i> GERI
                    </a>
                    <h4>{{ $paymentMethod->name }}</h4>
                </div>
                <div class="account-details" style="display: none;">
                    <!-- loading... -->
                </div>
                <div class="errors" style="display: none;">
                    <!-- loading... -->
                </div>
                <form data-type="POST" data-url="{{ url('/api/payment/create') }}" enctype="multipart/form-data">
                    <input type="hidden" name="method_id" value="{{ $methodId }}">
                    <input type="hidden" name="api_id" value="{{ $apiId }}">
                    <input type="hidden" name="player_id" value="{{ $playerId }}">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                    @if($paymentMethod->id == 1)
                    <div class="money-check-form">
                        <label for="bank_account">
                            <i class="fas fa-university"></i>
                            <select id="bank_account" name="bank_id">
                                <option value="">Seçiniz</option>
                                @foreach($bankAccounts as $bankAccount)
                                    @if($bankAccount->type_id == 1)
                                        <option value="{{ $bankAccount->id }}">{{ $bankAccount->banks->name }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 1)
                    <div class="money-check-form">
                        <label for="tc_number">
                            <i class="fas fa-user"></i>
                            <input id="tc_number" name="identity_number" type="text" placeholder="Kimlik Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 1)
                    <div class="money-check-form">
                        <label for="transaction_date">
                            <i class="fas fa-clock"></i>
                            <input id="transaction_date" name="transaction_date" type="text" placeholder="Işlem Tarihi">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 7)
                        <div class="money-check-form">
                            <label for="bank">
                                <i class="fas fa-university"></i>
                                <select id="bank" name="bank_id">
                                    <option value="">Seçiniz</option>
                                    @foreach($banks as $bank)
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endforeach
                                </select>
                            </label>
                        </div>
                    @endif

                    @if(
                        $paymentMethod->id == 3 ||
                        $paymentMethod->id == 4 ||
                        $paymentMethod->id == 5 ||
                        $paymentMethod->id == 7 ||
                        $paymentMethod->id == 8
                    )
                    <div class="money-check-form">
                        <label for="account_number">
                            <i class="fas fa-bong"></i>
                            <input id="account_number" name="account_number" type="text" placeholder="Hesap Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 7)
                        <div class="money-check-form">
                            <label for="iban">
                                <i class="fas fa-birthday-cake"></i>
                                <input id="iban" name="iban" type="text" placeholder="IBAN">
                            </label>
                        </div>
                    @endif

                    @if($paymentMethod->id == 7)
                        <div class="money-check-form">
                            <label for="branch_code">
                                <i class="fas fa-birthday-cake"></i>
                                <input id="branch_code" name="branch_code" type="text" placeholder="Şube Kodu">
                            </label>
                        </div>
                    @endif

                    @if(
                        $paymentMethod->id == 3 ||
                        $paymentMethod->id == 4 ||
                        $paymentMethod->id == 5 ||
                        $paymentMethod->id == 7
                    )
                    <div class="money-check-form">
                        <label for="firstname_and_lastname">
                            <i class="fas fa-user"></i>
                            <input id="firstname_and_lastname" name="firstname_and_lastname" type="text" placeholder="İsim ve Soyisim">
                        </label>
                    </div>
                    @endif

                    @if(
                        $paymentMethod->id == 3 ||
                        $paymentMethod->id == 4 ||
                        $paymentMethod->id == 5
                    )
                    <div class="money-check-form">
                        <label for="identity_number">
                            <i class="fas fa-user"></i>
                            <input id="identity_number" name="identity_number" type="text" placeholder="Kimlik Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 6)
                    <div class="money-check-form">
                        <label for="wallet_code">
                            <i class="fas fa-user"></i>
                            <input id="wallet_code" name="wallet_code" type="text" placeholder="Cüzdan Kodu">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 2)
                        <div class="money-check-form">
                            <label for="bank">
                                <i class="fas fa-university"></i>
                                <select id="bank" name="bank_id">
                                    <option value="">Seçiniz</option>
                                    @foreach($mobileBanks as $bank)
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endforeach
                                </select>
                            </label>
                        </div>
                    @endif

                    @if($paymentMethod->id == 2)
                    <div class="money-check-form">
                        <label for="sender_phone_number">
                            <i class="fas fa-phone"></i>
                            <input id="sender_phone_number" name="sender_phone_number" type="text" placeholder="Gönderici Telefon Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 2)
                    <div class="money-check-form">
                        <label for="receiver_phone_number">
                            <i class="fas fa-phone"></i>
                            <input id="receiver_phone_number" name="receiver_phone_number" type="text" placeholder="Alıcı Telefon Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 2)
                    <div class="money-check-form">
                        <label for="password">
                            <i class="fas fa-key"></i>
                            <input id="password" name="password" type="text" placeholder="Şifre">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 2)
                    <div class="money-check-form">
                        <label for="receiver_identity_number">
                            <i class="fas fa-user"></i>
                            <input id="receiver_identity_number" name="receiver_identity_number" type="text" placeholder="Alıcı Kimlik Numarası">
                        </label>
                    </div>
                    @endif

                    @if($paymentMethod->id == 2)
                    <div class="money-check-form">
                        <label for="receiver_birth_date">
                            <i class="fas fa-birthday-cake"></i>
                            <input id="receiver_birth_date" name="receiver_birth_date" type="text" placeholder="Alıcı Doğum Tarihi">
                        </label>
                    </div>
                    @endif

                    @if(
                        $paymentMethod->id == 1 ||
                        $paymentMethod->id == 2 ||
                        $paymentMethod->id == 3 ||
                        $paymentMethod->id == 4 ||
                        $paymentMethod->id == 5 ||
                        $paymentMethod->id == 6
                    )
                        <div class="money-check-form">
                            <label for="customer_note">
                                <i class="fas fa-sticky-note"></i>
                                <input name="customer_note" id="customer_note" type="text" placeholder="Kullanıcı Notu (İsteğe Bağlı)">
                            </label>
                        </div>
                    @endif

                    @if(
                        $paymentMethod->id == 1 ||
                        $paymentMethod->id == 2 ||
                        $paymentMethod->id == 3 ||
                        $paymentMethod->id == 4 ||
                        $paymentMethod->id == 5 ||
                        $paymentMethod->id == 6 ||
                        $paymentMethod->id == 7 ||
                        $paymentMethod->id == 8 ||
                        $paymentMethod->id == 9 ||
                        $paymentMethod->id == 10
                    )
                    <div class="money-check-form">
                        <label for="transaction_price">
                            <i class="fas fa-money-bill-alt"></i>
                            <input name="amount" id="transaction_price" type="text" placeholder="Miktar">
                        </label>
                    </div>
                    @endif

                    <button class="money-check-in" id="createPayment" type="button">GÖNDER</button>
                </form>
            </div>
        </div>
        @endif
    </div>

    <style>
        .money-check-form {
            width: calc(100%) !important;
        }
        .panel-content {
            padding: 0 !important;
        }
        .money-check-desc {
            margin-top: 0 !important;
        }
        .copy-btn {
            margin-top: 20px !important;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"
            integrity="sha384-xrRywqdh3PHs8keKZN+8zzc5TX0GRTLCcmivcbNJWm2rs5C8PRhcEn3czEjhAO9o"
            crossorigin="anonymous"></script>
    <script src="/assets/js/app.js"></script>
</body>
</html>
