<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Jekyll v3.8.5">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Payment Lobby</title>
    <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/css/fontawesome.min.css" rel="stylesheet">
</head>
<body>
    <div class="{{ request()->input('container') == 1 ? 'container' : '' }}">
        @if($errorPage)
            <div class="panel-home">
                <div class="panel-content">
                    <div class="payment-logo" style="text-align: center;margin-top: 20px;">
                        <img src="/assets/img/error.png">
                    </div>
                    <div class="payment-error-text" style="text-align: center;margin-top: 20px;font-size: 20px;">Böyle Bir Ödeme Sayfası ya da Ödeme Yöntemi Bulunamadı. Lütfen firmanız ile iletişime geçiniz.</div>
                </div>
            </div>
        @else
            <div class="payment-lobby">
                @foreach($paymentMethods as $method)
                <!--<div class="payment-method" href="{{ url('/payment/page/' . $method->id . '?api_id=' . $site->id . '&player_id=' . $player->id . '&mobile=' . $mobile) }}">
                    <a href="{{ url('/payment/page/' . $method->id . '?api_id=' . $site->id . '&player_id=' . $player->id . '&mobile=' . $mobile) }}">{{ $method->name }}</a>
                </div>-->

                <div class="payment-method" onclick="openPaymentMethod({{ $method->id }})">
                    <div class="icon">
                        <img alt="{{ $method->name }}" src="{{ $method->logo }}">
                    </div>
                    <a href="javascript:void(0);">{{ $method->name }}</a>
                </div>
                <div class="page-deposit-list-item-content page-deposit-list-item-content-shows payment-method-detail-url" id="paymentMethodUrl-{{ $method->id }}" style="display: none;">
                    <iframe allow="autoplay" allowfullscreen="" id="paymentUrl-{{ $method->id }}" src="" style="width: 100%;border: 0;height: {{ $method->id == 6 ? '750px' : '1500px' }};"></iframe>
                </div>
                <div class="payment-method-detail" id="paymentMethodDetail-{{ $method->id }}" style="display: none;">
                    <div class="account-details" style="display: none;">
                        <!-- loading... -->
                    </div>
                    <div class="errors" style="display: none;">
                        <!-- loading... -->
                    </div>
                    <form data-type="POST" data-url="/api/payment/create" enctype="multipart/form-data" id="formDetail-{{ $method->id }}">
                        <input type="hidden" name="method_id" value="{{ $method->id }}">
                        <input type="hidden" name="api_id" value="{{ $site->id }}">
                        <input type="hidden" name="player_id" value="{{ $player->id }}">
                        <input type="hidden" name="external_transaction_id" value="{{ !empty($externalTransactionId) ? $externalTransactionId : '' }}">
                        <!--<input type="hidden" name="bank_account_id" value="0">-->
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">

                        @if($method->id == 12)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Yatırım Linki
                                </div>
                                <div class="text col">
                                    <a class="btn btn-warning" href="//www.payturka.com/?hash=94c6f2f029c9adb96d313b50f92885e8" target="_blank">Hızlı ve Güvenli Cmt Yatırımı için Tıklayın</a>
                                </div>
                            </div>

                            <div class="account-item flex-container align-items-center">
                                <div class="text col">
                                    <span style="color: red;">Not: Cmt Yatırımı Yaptıktan Sonra Talep Oluşturmayı Unutmayınız !</span>
                                </div>
                            </div>
                        @endif

                        @if($method->id == 15)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Yatırım Linki
                                </div>
                                <div class="text col">
                                    <a class="btn btn-warning" href="//redin.club/Pays/4421333" target="_blank">Hızlı ve Güvenli Kredi Kartı Yatırımı için Tıklayın</a>
                                </div>
                            </div>

                            <div class="account-item flex-container align-items-center">
                                <div class="text col">
                                    <span style="color: red;">Not: Kredi Kartı Yatırımı Yaptıktan Sonra Talep Oluşturmayı Unutmayınız !</span><br />
                                    <span style="color: red;">- Aynı Karttan Ay İçinde Maximum 5000 TL Ödeme Yapabilirsiniz</span><br />
                                    <span style="color: red;">- Ödeme Yaparken İşlem Bitmeden Ekranı Kapatmayınız, Telefon Onayı Gerekebilir.</span><br />
                                    <span style="color: red;">- Kişisel Bilgilerinizi Doğru Giriniz.</span><br />
                                    <span style="color: red;">- Min 20, Max 750 TL Yatırım Yapabilirsiniz.</span>
                                </div>
                            </div>
                        @endif

                        @if($method->id == 1)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Banka Seçiniz
                                </div>
                                <div class="text col">
                                    <select class="form-control" id="__bank_account__" name="bank_id">
                                        <option value="">Seçiniz</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        @endif

                        @if($method->id == 1)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Yatırım Yapılan Hesap Adı
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="process_account_name">
                                    <span style="color: darkred">Lütfen yatırım yapmış olduğunuz hesap adını giriniz, kendi hesap adınızı girmeyiniz.</span>
                                </div>
                            </div>
                            <!--<div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Banka Seçiniz
                                </div>
                                <div class="text col">
                                    <select class="form-control" id="bank_account_list_load" name="bank_account_id">
                                        <option value="">Seçiniz</option>
                                    </select>
                                </div>
                            </div>-->
                        @endif

                        @if($method->id == 1)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    İşlem Tarihi
                                </div>
                                <div class="text col">
                                    <input type="datetime-local" class="form-control" name="transaction_date" value="{{ date('Y-m-d') }}T{{ date('H:i') }}">
                                </div>
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Banka Seçiniz
                                </div>
                                <div class="text col">
                                    <select class="form-control" id="bank" name="bank_id">
                                        <option value="">Seçiniz</option>
                                        @foreach($banks as $bank)
                                            <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        @endif

                        @if(
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 7 ||
                            $method->id == 8 ||
                            $method->id == 12
                        )
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Hesap Numarası
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="account_number">
                                </div>
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    IBAN
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="iban">
                                </div>
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Şube Kodu
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="branch_code">
                                </div>
                            </div>
                        @endif

                        @if(
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 7 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    İsim ve Soyisim
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="firstname_and_lastname">
                                </div>
                            </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 12
                        )
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Kimlik No
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="identity_number">
                                </div>
                            </div>
                        @endif

                        @if(
                            $method->id == 6 ||
                            $method->id == 11
                        )
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Cüzdan Kodu
                                </div>
                                <div class="text col">
                                    <input type="text" class="form-control" name="wallet_code">
                                </div>
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="account-item flex-container align-items-center">
                                <div class="ai-title">
                                    Banka Seçiniz
                                </div>
                                <div class="text col">
                                    <select class="form-control" id="bank" name="bank_id">
                                        <option value="">Seçiniz</option>
                                        @foreach($mobileBanks as $bank)
                                            <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Gönderici Tel No
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="sender_phone_number">
                            </div>
                        </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Alıcı Tel No
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="receiver_phone_number">
                            </div>
                        </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Şifre
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="password">
                            </div>
                        </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Veriliş/Geçerlilik Tarihi
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="identity_date">
                                <span style="color: red">Eski Kimlik ise Veriliş, Yeni Kimlik ise Geçerlilik Tarihi Giriniz !</span>
                            </div>
                        </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Alıcı Kimlik No
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="receiver_identity_number">
                            </div>
                        </div>
                        @endif

                        @if($method->id == 2)
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Alıcı Doğum Tarihi
                            </div>
                            <div class="text col">
                                <input type="date" class="form-control" name="receiver_birth_date">
                            </div>
                        </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 2 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Kullanıcı Notu
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="customer_note">
                            </div>
                        </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 2 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 6 ||
                            $method->id == 7 ||
                            $method->id == 8 ||
                            $method->id == 9 ||
                            $method->id == 10 ||
                            $method->id == 11 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                        <div class="account-item flex-container align-items-center">
                            <div class="ai-title">
                                Miktar
                            </div>
                            <div class="text col">
                                <input type="text" class="form-control" name="amount">
                            </div>
                        </div>
                        @endif

                        <div class="account-item flex-container align-items-center bb-1">
                            <div class="ai-title col">
                                <div class="flex-container m-0">
                                    <div class="w-100">
                                        <button class="btn blue bold w-100" id="createPayment" type="button">
                                            Talep Gönder
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                @endforeach
            </div>
        @endif
    </div>

    <style>
        .payment-lobby {}

        .payment-method {
            padding: 8px 20px;
            border-top: 1px solid #e3e3e3;
            display: block;
        }

        .payment-method a {
            font-size: 16px;
            color: #3e3e3e;
        }

        .account-item {
            padding: 8px 30px;
            border-top: 1px solid #e3e3e3;
        }
        .align-items-center {
            -webkit-box-align: end;
            -ms-flex-align: end;
            align-items: center;
        }
        .flex-container {
            display: -webkit-box;
            display: -ms-flexbox;
            display: flex;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap;
            margin: 0 -15px;
        }
        .account-item .ai-title {
            width: 160px;
        }
        .account-item .ai-title, .account-item .text {
            font-size: 16px;
            padding: 5px 0;
        }
        .account-item .ai-title, .account-item .text {
            font-size: 16px;
            padding: 5px 0;
        }
        .col {
            flex-basis: 0;
            -webkit-box-flex: 1;
            -ms-flex-positive: 1;
            flex-grow: 1;
        }
        .bar .text, .col, .overlay .dialog, .select, .selectwrap, .validator, header .logo, img, select {
            max-width: 100%;
        }
        .form-control {
            border: 1px solid #dcdbdb;
            width: 100%;
            display: block;
            border-radius: 0;
        }
        .input, input {
            padding: 5px 15px;
            height: 34px;
            color: #3E3E40;
            border: 1px solid #ccc;
        }
        .big-btn, .inline-text, .input, .msg-box .text, .select, .text-error, input, select {
            font-size: 16px;
        }
        .bb-1 {
            border-bottom: 1px solid #e3e3e3!important;
        }
        .m-0 {
            margin: 0!important;
        }
        .w-100 {
            width: 100%!important;
        }
        .w-100, .w-13, .w-14, .w-16, .w-20, .w-25, .w-30, .w-33, .w-41, .w-43, .w-50, .w-58, .w-66, .w-75, .w-8, .w-83, .w-91 {
            padding: 0 15px;
            box-sizing: border-box;
        }
        .btn.blue {
            background: #257396;
            border-radius: 0;
            line-height: 1;
        }
        .btn {
            height: 34px;
            padding: 7px 33px;
            color: #FFF;
            font-size: 16px;
            display: inline-block;
            border: 0;
        }
        .bold, .strong, b, strong {
            font-weight: 700!important;
        }
        * {
            box-sizing: border-box;
            font-family: "Roboto Condensed",helvetica,sans-serif;
        }
        .account-details {
            width: 100%;
            display: inline-block;
            background: #e9f969;
            padding: 20px;
            position: relative;
        }
        .account-detail-title {
            width: 100%;
            font-size: 18px;
        }
        .account-detail-content {
            width: 100%;
            margin-top: 10px;
        }
        .account-detail-content span {
            width: 100%;
            display: inline-block;
        }
        .copy-btn {
            width: 100px;
            position: absolute;
            float: right;
            right: 0;
            top: 0;
            background: #ca2020;
            color: #fff;
            text-align: center;
            text-decoration: none;
            height: 40px;
            line-height: 40px;
        }
        .copy-btn:hover {
            color: #eee;
            text-decoration: none;
        }
        .errors {
            margin-bottom: -20px;
            width: 100%;
            display: inline-block;
        }
        .alert {
            border-radius: 0 !important;
        }
        .icon {
            width: 27px;
            float: left;
            margin-right: 10px;

        }
    </style>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"
            integrity="sha384-xrRywqdh3PHs8keKZN+8zzc5TX0GRTLCcmivcbNJWm2rs5C8PRhcEn3czEjhAO9o"
            crossorigin="anonymous"></script>
    <script src="/assets/js/app.js"></script>

    @if(!empty(request()->input('method')))
        <script>
            $(function () {
                openPaymentMethod({{ request()->input('method') }});
            });
        </script>
    @endif
</body>
</html>
