<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Jekyll v3.8.5">
    <title>Payment Lobby</title>
    <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/css/fontawesome.min.css" rel="stylesheet">
    <link href="/assets/css/app.css" rel="stylesheet">
</head>
<body>
    <div class="{{ request()->input('container') == 1 ? 'container' : '' }}">
        @if($errorPage)
            <div class="panel-home">
                <div class="panel-content">
                    <div class="payment-logo">
                        <img src="/assets/img/error.png">
                    </div>
                    <div class="payment-error-text">Böyle Bir Ödeme Sayfası ya da Ödeme Yöntemi Bulunamadı. Lütfen firmanız ile iletişime geçiniz.</div>
                </div>
            </div>
        @else
            <div class="tablo-list">
                <div class="tablo-one">
                    <table>
                        <tbody>
                        <tr>
                            <td>&nbsp;</td>
                            <td>Yöntem</td>
                            <td>Işlem Limiti</td>
                            <td>Işlem Ücreti</td>
                            <td>Süre</td>
                            @if($type == 1)
                                <td>Nakit Bonus</td>
                            @endif
                            <td>Işlemler</td>
                        </tr><!---->
                        @foreach($paymentMethods as $method)
                        <tr style="height: 80px;" class="ng-star-inserted">
                            <td><img alt="{{ $method->name }}" src="{{ $method->logo }}"></td>
                            <td>{{ $method->name }}</td>
                            <td>
                                <span style="width: 100%;display: block;height: 20px;">Min: {{ $method->min_amount }} TL</span>
                                <span style="width: 100%;display: block;">Max: {{ $method->max_amount }} TL</span>
                            </td>
                            <td>{{ $method->fee == 0 ? 'Ücretsiz' : $method->fee }}</td>
                            <td>{{ $method->time }}</td>
                            @if($type == 1)
                                <td>{{ $method->cash_bonus }}</td>
                            @endif
                            <td>
                                <a class="plus-btn" href="{{ url('/payment/page/' . $method->id . '?api_id=' . $site->id . '&player_id=' . $player->id . '&mobile=' . $mobile) }}">
                                    <i class="fas fa-plus"></i>
                                    SEÇ
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    </div>

    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"
            integrity="sha384-xrRywqdh3PHs8keKZN+8zzc5TX0GRTLCcmivcbNJWm2rs5C8PRhcEn3czEjhAO9o"
            crossorigin="anonymous"></script>
    <script src="/assets/js/app.js"></script>
</body>
</html>
