$(document).ready(function() {
    jQuery('#export-to-excel').bind("click", function() {
        $('#excelParams').val($('#transactionForm').serialize());
        $('#export-excel-form').submit();
        $('#excelParams').val('');
    });

    jQuery('#export-to-pdf').bind("click", function() {
        alert('Henüz aktif değildir!');
    });

    /*
    $(document).on('click', '#export-to-excel', function() {
        $('#excelParams').val($('#transactionForm').serialize());
        $('#export-excel-form').submit();
        $('#excelParams').val('');
    });
     */
});

$(function () {
    $('#bank_account').change(function () {
        const bankId = parseInt($(this).val()) || 0;

        if (bankId > 0)
            getBankAccount(1, bankId);
    });

    $('#param_bank_account').change(function () {
        const bankId = parseInt($(this).val()) || 0;

        if (bankId > 0)
            getBankAccount(5, bankId);
    });

    $(document).on('click', '#createPayment', function(event) {
        var form_btn  = $(this);
        var form_url  = $(this).closest('form').attr('data-url');
        var form_type = $(this).closest('form').attr('data-type');
        var form_data = new FormData($(this).closest('form')[0]);

        form_btn.attr('disabled', true);
        $.ajax({
            type: form_type,
            url: form_url,
            data: form_data,
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (data) {
                getAlert(data.type, data.message);

                $("html, body").animate({ scrollTop: 0 }, "normal");
                form_btn.attr('disabled', false);

                if (data.type == 'success') {
                    if (data.url == 1) {
                        $('.payment-method-detail').hide();
                        $('#paymentMethodDetail-' + data.method_id).hide();
                        $('#paymentMethodUrl-' + data.method_id).show();
                        $('.account-details').hide().html('');
                        $('.errors').html('');
                        document.getElementById('paymentUrl-' + data.method_id).src = data.payment_method_url;
                    } else {
                        setTimeout('window.location.href="/payment/success"', 2000);
                    }
                }
            }
        });
        event.preventDefault();
    });

    $(document).on('click', '.detailTransaction', function() {
        var id = $(this).attr('process-id');
        showTransaction(id);
    });

    $(document).on('click', '#approvedTransaction', function() {
        const confirmed = confirm("Bu işlemi yapmak istediğinize emin misiniz?");

        if (!confirmed) return;

        var form_btn  = $(this);
        var id = $(this).attr('process-id');
        var formToken = $('meta[name="csrf-token"]').attr('content');

        form_btn.attr('disabled', true);

        $.ajax({
            type: 'POST',
            url: '/admin/transactions/status/' + id,
            data: 'transaction_status=1',
            headers: {
                'X-CSRF-Token': formToken
            },
            success: function (data) {
                getAlert(data.type, data.message);
                showTransaction(id);
                transactionList();
                form_btn.attr('disabled', false);
            }
        });
    });

    $(document).on('click', '#declinedTransaction', function() {
        var form_btn  = $(this);
        var id = $(this).attr('process-id');
        var payNote = $('textarea[name=pay_note]').val();
        var formToken = $('meta[name="csrf-token"]').attr('content');

        $('#payNoteTransaction').show();

        if (payNote.length < 3 || payNote === "" || payNote === undefined) {
            getAlert('error', 'Talep iptal edilirken lütfen açıklama yazınız.');
            return false;
        }

        form_btn.attr('disabled', true);

        $.ajax({
            type: 'POST',
            url: '/admin/transactions/status/' + id,
            data: 'transaction_status=2&pay_note=' + payNote,
            headers: {
                'X-CSRF-Token': formToken
            },
            success: function (data) {
                getAlert(data.type, data.message);
                showTransaction(id);
                transactionList();
                form_btn.attr('disabled', false);
            }
        });
    });

    $(document).on('click', '#checkingTransaction', function() {
        var form_btn  = $(this);
        var id = $(this).attr('process-id');
        var formToken = $('meta[name="csrf-token"]').attr('content');

        form_btn.attr('disabled', true);

        $.ajax({
            type: 'POST',
            url: '/admin/transactions/status/' + id,
            data: 'transaction_status=3',
            headers: {
                'X-CSRF-Token': formToken
            },
            success: function (data) {
                getAlert(data.type, data.message);
                showTransaction(id);
                transactionList();
                form_btn.attr('disabled', false);
            }
        });
    });

    $(document).on('click', '#transactionFilter', function() {
        $('input[name=page]').val(1);
        transactionList();
    });

    $(document).on('click', '#reportFilter', function() {
        $('input[name=page]').val(1);
        reportList();
    });

    $(document).on('click', '#reportPlayers', function() {
        $('input[name=page]').val(1);
        playerList();
    });

    $(document).on('click', '#logFilter', function() {
        $('input[name=page]').val(1);
        logList();
    });

    $(document).on('click', '#apiLogFilter', function() {
        $('input[name=page]').val(1);
        apiLogList();
    });

    $(document).on('click', '#cronJobFilter', function() {
        $('input[name=page]').val(1);
        cronJobList();
    });

    $(document).on('click', '#accountListFilter', function() {
        $('input[name=page]').val(1);
        accountList();
    });

    $(document).on('keyup', '#accountSearchText', function() {
        $('input[name=page]').val(1);
        var searchLength = $('#accountSearchText').val().length;
        if (searchLength >= 3) {
            accountList();
        } else if (searchLength === 0) {
            accountList();
        }
    });

    $("input[name=transaction_id]").on('keyup', function (e) {
        if (e.key === 'Enter' || e.keyCode === 13) {
            $('input[name=page]').val(1);
            transactionList();
        }
    });

    $(document).on('click', '#checkMailServer', function() {
        var mailServer = $('select[name="mail_server"]').val();
        var mailUsername = $('input[name="mail_username"]').val();
        var mailPassword = $('input[name="mail_password"]').val();
        var formToken = $('meta[name="csrf-token"]').attr('content');

        $('#responseMailServer').html('<div class="spinner-border" role="status">\n' +
            '  <span class="sr-only">Loading...</span>\n' +
            '</div>');

        $.ajax({
            type: 'POST',
            url: '/admin/account-management/accounts/check-mail-server',
            data: 'mail_server=' + mailServer + '&mail_username=' + mailUsername + '&mail_password=' + mailPassword,
            dataType: 'json',
            headers: {
                'X-CSRF-Token': formToken
            },
            success: function (data) {
                if (data.status) {
                    $('input[name=mail_server_check]').val(1);
                    $('#responseMailServer')
                        .html('<span class="btn btn-success">' + data.message + '</span>');
                } else {
                    $('input[name=mail_server_check]').val(0);
                    $('#responseMailServer')
                        .html('<button type="button" class="btn btn-warning" id="checkMailServer">Test Et</button>' +
                            '<span style="float: right" class="btn btn-danger">' + data.message + '</span>');
                }
            }
        });
    });
});

function sandBoxDepositSuccess() {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    var formHash = $('meta[name="hash"]').attr('content');
    $(".btn-success").prop('disabled', true);

    $.ajax({
        type: 'POST',
        url: '/sandbox/deposit-callback',
        data: 'hash=' + formHash + '&is_success=1',
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#responseSandBox').html(data);
            $(".btn-success").prop('disabled', false);
        }
    });
}

function sandBoxDepositFail() {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    var formHash = $('meta[name="hash"]').attr('content');
    $(".btn-danger").prop('disabled', true);

    $.ajax({
        type: 'POST',
        url: '/sandbox/deposit-callback',
        data: 'hash=' + formHash + '&is_success=2',
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#responseSandBox').html(data);
            $(".btn-danger").prop('disabled', false);
        }
    });
}

function sandBoxDrawSuccess() {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    var formHash = $('meta[name="hash"]').attr('content');
    $(".btn-success").prop('disabled', true);

    $.ajax({
        type: 'POST',
        url: '/sandbox/withdraw-callback',
        data: 'hash=' + formHash + '&is_success=1',
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#responseSandBox').html(data);
            $(".btn-success").prop('disabled', false);
        }
    });
}

function sandBoxDrawFail() {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    var formHash = $('meta[name="hash"]').attr('content');
    $(".btn-danger").prop('disabled', true);

    $.ajax({
        type: 'POST',
        url: '/sandbox/withdraw-callback',
        data: 'hash=' + formHash + '&is_success=2',
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#responseSandBox').html(data);
            $(".btn-danger").prop('disabled', false);
        }
    });
}

function transactionList() {
    var form_data = $('#transactionForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        type: 'POST',
        url: '/admin/transactions/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadTransactions').html(data);
            generatePaginator();
        }
    });
}

function setPage(pageNumber) {
    $('input[name=page]').val(pageNumber);

    if (window.location.pathname == '/admin/players') {
        playerList();
    } else if (window.location.pathname == '/admin/logs') {
        logList();
    } else if (window.location.pathname == '/admin/api_logs') {
        apiLogList();
    } else if (window.location.pathname == '/admin/cron_jobs') {
        cronJobList();
    } else if (window.location.pathname == '/admin/push-bullet') {
        pushBulletList();
    } else if (window.location.pathname == '/admin/account-management/accounts') {
        accountList();
    } else {
        transactionList();
    }
}

function generatePaginator() {
    let totalRow = transactionPaginate.totalRow;
    let perPage = transactionPaginate.perPage;
    let currentPage = transactionPaginate.currentPage;

    var pagination_options = {
        num_edge_entries: 2,
        num_display_entries: 8,
        items_per_page: 20,
        current_page: ($('input[name=page]').val()-1)
    }

    $("#Pagination").pagination(totalRow, pagination_options);
    $('#paginationCount').html(totalRow);
}

function reportList() {
    var form_data = $('#reportForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/reports/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadReports').html(data);
            spinnerHide();
        }
    });
}

function playerList() {
    var form_data = $('#playerForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/players/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadPlayers').html(data);
            generatePaginator();
            spinnerHide();
        }
    });
}

function logList() {
    var form_data = $('#logForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/logs/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadLogs').html(data);
            generatePaginator();
            spinnerHide();
        }
    });
}

function apiLogList() {
    var form_data = $('#apiLogForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/api_logs/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadApiLogs').html(data);
            generatePaginator();
            spinnerHide();
        }
    });
}

function cronJobList() {
    var form_data = $('#cronJobForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/cron_jobs/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadCronJobs').html(data);
            generatePaginator();
            spinnerHide();
        }
    });
}

function runCronJob(e, typeId) {
    e.target.disabled = true;
    $.ajax({
        type: 'GET',
        url: '/admin/cron_jobs/run/' + typeId,
        success: function (data) {
            cronJobList();
            e.target.disabled = false;
        }
    });
}

function exportExcel(e) {
    e.target.disabled = true;
    var formToken = $('meta[name="csrf-token"]').attr('content');
    $.ajax({
        type: 'POST',
        url: '/admin/transactions/export-excel',
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function () {
            //cronJobList();
            e.target.disabled = false;
        }
    });
}

function openSmsTab(status) {
    $('input[name=status]').val(status);
    $('#smsStatus0').removeClass('active');
    $('#smsStatus1').removeClass('active');
    $('#smsStatus2').removeClass('active');
    $('#smsStatus' + status).addClass('active');
    pushBulletList();
}

function pushBulletList() {
    var form_data = $('#smsForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        type: 'POST',
        url: '/admin/push-bullet/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadSms').html(data);
            generatePaginator();
        }
    });
}

function pushBulletDetail(id) {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/push-bullet/detail/' + id,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#pushBulletDetail').html(data);
            spinnerHide();
        }
    });
}

function pushBulletDelete(id) {
    $.ajax({
        type: 'GET',
        url: '/admin/push-bullet/delete/' + id,
        success: function (data) {
            getAlert(data.type, data.message);
            pushBulletList();
            pushBulletDetail(0);
        }
    });
}

function accountList() {
    var form_data = $('#accountListForm').serialize();
    var formToken = $('meta[name="csrf-token"]').attr('content');
    spinnerShow();

    $.ajax({
        type: 'POST',
        url: '/admin/account-management/accounts/list',
        data: form_data,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            $('#loadAccountList').html(data);
            generatePaginator();
            spinnerHide();
        }
    });
}

function spinnerShow() {
    $('#loadMainSpinner').show();
    $('#loadMainDiv').hide();
}

function spinnerHide() {
    $('#loadMainSpinner').hide();
    $('#loadMainDiv').show();
}

function getBankAccount(typeId, bankId) {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    let accountDetailsHtml = '';
    $('.account-details').hide().html(accountDetailsHtml);

    bankId = parseInt(bankId) || 0;

    $.ajax({
        type: 'POST',
        url: '/api/bank_account/' + typeId + '/' + bankId,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            if (data.type == 'success') {
                if (typeId == 1) {
                    accountDetailsHtml += '<div class="account-detail-title">HESAP BİLGİSİ</div>';
                    accountDetailsHtml += '<div class="account-detail-content">';
                    accountDetailsHtml += '<span><b>Hesap Sahibi:</b> ' + data.response.account_owner + '</span>';
                    accountDetailsHtml += '<span><b>Hesap Numarası:</b> ' + data.response.account_number + '</span>';
                    accountDetailsHtml += '<span><b>Şube Kodu:</b> ' + data.response.branch_code + '</span>';
                    accountDetailsHtml += '<span><b>IBAN:</b> ' + data.response.iban + '</span>';
                    accountDetailsHtml += '</div>';
                    accountDetailsHtml += '<a class="money-check-in copy-btn" href="javascript:void(0);" onclick="copyToClipboard(\'' + data.response.iban + '\')">KOPYALA</a>';

                    $('input[name=bank_account_id]').val(data.response.id);
                    $('.account-details').show().html(accountDetailsHtml);
                } else if (typeId == 2 || typeId == 3 || typeId == 4) {
                    accountDetailsHtml += '<div class="account-detail-title">HESAP BİLGİSİ</div>';
                    accountDetailsHtml += '<div class="account-detail-content">';
                    accountDetailsHtml += '<span><b>Hesap Sahibi:</b> ' + data.response.account_owner + '</span>';
                    accountDetailsHtml += '<span><b>Hesap Numarası:</b> ' + data.response.account_number + '</span>';
                    accountDetailsHtml += '</div>';
                    accountDetailsHtml += '<a class="money-check-in copy-btn" href="javascript:void(0);" onclick="copyToClipboard(\'' + data.response.account_number + '\')">KOPYALA</a>';

                    $('input[name=bank_account_id]').val(data.response.id);
                    $('.account-details').show().html(accountDetailsHtml);
                } else if (typeId == 5) {
                    accountDetailsHtml += '<div class="account-detail-title">HESAP BİLGİSİ</div>';
                    accountDetailsHtml += '<div class="account-detail-content">';
                    accountDetailsHtml += '<span><b>Hesap Sahibi:</b> ' + data.response.account_owner + '</span>';
                    accountDetailsHtml += '<span><b>IBAN:</b> ' + data.response.iban + '</span>';
                    accountDetailsHtml += '<span><b>Açıklama:</b> ' + data.response.description + '</span>';
                    accountDetailsHtml += '</div>';
                    accountDetailsHtml += '<a class="money-check-in copy-btn" href="javascript:void(0);" onclick="copyToClipboard(\'' + data.response.iban + '\')">KOPYALA</a>';

                    $('input[name=bank_account_id]').val(data.response.id);
                    $('.account-details').show().html(accountDetailsHtml);
                } else if (typeId == 6) {
                    accountDetailsHtml += '<div class="account-detail-title">HESAP BİLGİSİ</div>';
                    accountDetailsHtml += '<div class="account-detail-content">';
                    accountDetailsHtml += '<span><b>Hesap Sahibi:</b> ' + data.response.account_owner + '</span>';
                    accountDetailsHtml += '<span><b>Kart Numarası:</b> ' + data.response.account_number + '</span>';
                    accountDetailsHtml += '</div>';
                    accountDetailsHtml += '<a class="money-check-in copy-btn" href="javascript:void(0);" onclick="copyToClipboard(\'' + data.response.account_number + '\')">KOPYALA</a>';

                    $('input[name=bank_account_id]').val(data.response.id);
                    $('.account-details').show().html(accountDetailsHtml);
                }
            } else {
                accountDetailsHtml += '<div class="account-detail-title">' + data.message + '</div>';
                $('.account-details').show().html(accountDetailsHtml);
            }
        }
    });
}

function getBankAccounts(typeId) {
    var formToken = $('meta[name="csrf-token"]').attr('content');
    let accountDetailsHtml = '<option value="">Seçiniz</option>';
    $('#bank_account_list_load').html(accountDetailsHtml);

    $.ajax({
        type: 'POST',
        url: '/api/bank_accounts/' + typeId,
        headers: {
            'X-CSRF-Token': formToken
        },
        success: function (data) {
            if (data.type == 'success') {
                if (typeId == 1) {
                    $.each(data.response, function( index, value ) {
                        $('#bank_account_list_load').append('<option value="' + value.id + '">' + value.bank_name + ' - ' + value.account_owner + '</option>');
                    });
                }
            }
        }
    });
}

function showTransaction(transactionId) {
    $.ajax({
        type: 'GET',
        url: '/admin/transactions/detail/' + transactionId,
        success: function (data) {
            $('#loadDetail').html(data);
        }
    });
}

function countTransaction() {
    $.ajax({
        type: 'GET',
        url: '/admin/transactions/count',
        success: function (data) {
            $('.depositCount').html(data.list.deposit);
            $('.withdrawCount').html(data.list.withdraw);
            $('.inProgressDepositCount').html(data.list.in_progress);

            if (data.list.deposit > 0 || data.list.withdraw > 0 || data.list.in_progress > 0) {
                if (transactionRefresh == 1) {
                    transactionList();
                }

                if (!data.control) {
                    document.getElementById("audio").play().catch();
                }
            }
        }
    });
}

function checkAutoTransaction() {
    $.ajax({
        type: 'GET',
        url: '/admin/transactions/check-auto',
        success: function (data) {
            console.log('Auto Transaction Success', data);
        }
    });
}

function setAccountStatus(id, status, alert = 0) {
    if (alert == 1 && confirm('Kullanım Dışı hesabın durumunu değiştirmek istediğinize emin misiniz ?')) {
        $.ajax({
            type: 'GET',
            url: '/admin/account-management/accounts/status/' + id + '/' + status,
            success: function (data) {
                getAlert(data.type, data.message);
                accountList();
            }
        });
    } else if (alert == 0) {
        $.ajax({
            type: 'GET',
            url: '/admin/account-management/accounts/status/' + id + '/' + status,
            success: function (data) {
                getAlert(data.type, data.message);
                accountList();
            }
        });
    }
}

function openPaymentMethod(methodId) {
    $('.payment-method-detail').hide();
    $('.payment-method-detail-url').hide();
    $('#paymentMethodDetail-' + methodId).toggle();
    $('.account-details').hide().html('');
    $('.errors').html('');
    document.getElementById("formDetail-" + methodId).reset();

    if (methodId == 1) {
        //getBankAccount(1);
        getBankAccounts(1);
    } else if (methodId == 3) {
        getBankAccount(2);
    } else if (methodId == 4) {
        getBankAccount(3);
    } else if (methodId == 5) {
        getBankAccount(4);
    } else if (methodId == 10) {
        getBankAccount(6);
    }
}

function copyToClipboard(text) {
    getAlert('success', 'Hesap Bilgisi Kopyalandı !');

    if (window.clipboardData && window.clipboardData.setData) {
        // IE specific code path to prevent textarea being shown while dialog is visible.
        return clipboardData.setData("Text", text);

    } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
        var textarea = document.createElement("textarea");
        textarea.textContent = text;
        textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
        document.body.appendChild(textarea);
        textarea.select();
        try {
            return document.execCommand("copy"); // Security exception may be thrown by some browsers.
        } catch (ex) {
            console.warn("Copy to clipboard failed.", ex);
            return false;
        } finally {
            document.body.removeChild(textarea);
        }
    }
}

function getAlert(type, message)
{
    if (type == 'success')
        $('.errors').show().html('<div class="alert alert-success" role="alert">' + message + '</div>');
    else if (type == 'error')
        $('.errors').show().html('<div class="alert alert-danger" role="alert">' + message + '</div>');
    else if (type == 'info')
        $('.errors').show().html('<div class="alert alert-info" role="alert">' + message + '</div>');
    else if (type == 'warning')
        $('.errors').show().html('<div class="alert alert-info" role="alert">' + message + '</div>');
    else
        $('.errors').show().html('<div class="alert alert-default" role="alert">' + message + '</div>');

    var alertInterval = setInterval(function () {
        $('.errors').hide();
        clearInterval(alertInterval);
    }, 2000);
}

function copyToClipboard(text) {
    getAlert('success', 'Hesap Bilgisi Kopyalandı !');

    if (window.clipboardData && window.clipboardData.setData) {
        // IE specific code path to prevent textarea being shown while dialog is visible.
        return clipboardData.setData("Text", text);

    } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
        var textarea = document.createElement("textarea");
        textarea.textContent = text;
        textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
        document.body.appendChild(textarea);
        textarea.select();
        try {
            return document.execCommand("copy"); // Security exception may be thrown by some browsers.
        } catch (ex) {
            console.warn("Copy to clipboard failed.", ex);
            return false;
        } finally {
            document.body.removeChild(textarea);
        }
    }
}

/**
 * This jQuery plugin displays pagination links inside the selected elements.
 *
 * @author Gabriel Birke (birke *at* d-scribe *dot* de)
 * @version 1.2
 * @param {int} maxentries Number of entries to paginate
 * @param {Object} opts Several options (see README for documentation)
 * @return {Object} jQuery Object
 */
jQuery.fn.pagination = function(maxentries, opts){
    opts = jQuery.extend({
        items_per_page:10,
        num_display_entries:10,
        current_page:0,
        num_edge_entries:0,
        link_to:"#",
        prev_text:"Geri",
        next_text:"İleri",
        ellipse_text:"...",
        prev_show_always:true,
        next_show_always:true,
        callback:function(){return false;}
    },opts||{});

    return this.each(function() {
        /**
         * Calculate the maximum number of pages
         */
        function numPages() {
            return Math.ceil(maxentries/opts.items_per_page);
        }

        /**
         * Calculate start and end point of pagination links depending on
         * current_page and num_display_entries.
         * @return {Array}
         */
        function getInterval()  {
            var ne_half = Math.ceil(opts.num_display_entries/2);
            var np = numPages();
            var upper_limit = np-opts.num_display_entries;
            var start = current_page>ne_half?Math.max(Math.min(current_page-ne_half, upper_limit), 0):0;
            var end = current_page>ne_half?Math.min(current_page+ne_half, np):Math.min(opts.num_display_entries, np);
            return [start,end];
        }

        /**
         * This is the event handling function for the pagination links.
         * @param {int} page_id The new page number
         */
        function pageSelected(page_id, evt){
            current_page = page_id;
            drawLinks();
            var continuePropagation = opts.callback(page_id, panel);
            if (!continuePropagation) {
                if (evt.stopPropagation) {
                    evt.stopPropagation();
                }
                else {
                    evt.cancelBubble = true;
                }
            }
            return continuePropagation;
        }

        /**
         * This function inserts the pagination links into the container element
         */
        function drawLinks() {
            panel.empty();
            var interval = getInterval();
            var np = numPages();
            // This helper function returns a handler function that calls pageSelected with the right page_id
            var getClickHandler = function(page_id) {
                return function(evt){ return pageSelected(page_id,evt); }
            }
            // Helper function for generating a single link (or a span tag if it's the current page)
            var appendItem = function(page_id, appendopts){
                page_id = page_id<0?0:(page_id<np?page_id:np-1); // Normalize page id to sane value
                appendopts = jQuery.extend({text:page_id+1, classes:""}, appendopts||{});
                if(page_id == current_page){
                    var lnk = jQuery("<span class='current'>"+(appendopts.text)+"</span>");
                }
                else
                {
                    var lnk = jQuery("<a onclick='setPage(" + (page_id+1) + ");'>"+(appendopts.text)+"</a>")
                        .bind("click", getClickHandler(page_id))
                        .attr('href', opts.link_to.replace(/__id__/,page_id));


                }
                if(appendopts.classes){lnk.addClass(appendopts.classes);}
                panel.append(lnk);
            }
            // Generate "Previous"-Link
            if(opts.prev_text && (current_page > 0 || opts.prev_show_always)){
                appendItem(current_page-1,{text:opts.prev_text, classes:"prev"});
            }
            // Generate starting points
            if (interval[0] > 0 && opts.num_edge_entries > 0)
            {
                var end = Math.min(opts.num_edge_entries, interval[0]);
                for(var i=0; i<end; i++) {
                    appendItem(i);
                }
                if(opts.num_edge_entries < interval[0] && opts.ellipse_text)
                {
                    jQuery("<span>"+opts.ellipse_text+"</span>").appendTo(panel);
                }
            }
            // Generate interval links
            for(var i=interval[0]; i<interval[1]; i++) {
                appendItem(i);
            }
            // Generate ending points
            if (interval[1] < np && opts.num_edge_entries > 0)
            {
                if(np-opts.num_edge_entries > interval[1]&& opts.ellipse_text)
                {
                    jQuery("<span>"+opts.ellipse_text+"</span>").appendTo(panel);
                }
                var begin = Math.max(np-opts.num_edge_entries, interval[1]);
                for(var i=begin; i<np; i++) {
                    appendItem(i);
                }

            }
            // Generate "Next"-Link
            if(opts.next_text && (current_page < np-1 || opts.next_show_always)){
                appendItem(current_page+1,{text:opts.next_text, classes:"next"});
            }
        }

        // Extract current_page from options
        var current_page = opts.current_page;
        // Create a sane value for maxentries and items_per_page
        maxentries = (!maxentries || maxentries < 0)?1:maxentries;
        opts.items_per_page = (!opts.items_per_page || opts.items_per_page < 0)?1:opts.items_per_page;
        // Store DOM element for easy access from all inner functions
        var panel = jQuery(this);
        // Attach control functions to the DOM element
        this.selectPage = function(page_id){ pageSelected(page_id);}
        this.prevPage = function(){
            if (current_page > 0) {
                pageSelected(current_page - 1);
                return true;
            }
            else {
                return false;
            }
        }
        this.nextPage = function(){
            if(current_page < numPages()-1) {
                pageSelected(current_page+1);
                return true;
            }
            else {
                return false;
            }
        }
        // When all initialisation is done, draw the links
        drawLinks();
        // call callback function
        opts.callback(current_page, this);
    });
}
