# Hashing

---

Below are the necessary parameters for hashing calculation and sample php code for calculation. This hashing mechanic should be re-created on your seamless side in the response code and presented to us for control. If any incorrect creation method is made in this regard, the integration test fails and you may get an error during the transaction process.

<h3>Params</h3>

| Parameter | Type | Description | Requirement |
| : |   :   |  :  |  :  |
| api_id | integer | API Id for Merchant | Yes |
| api_key | string | API Key for Merchant | Yes |
| user_id | integer | User Id that started the process | Yes |
| username | string | Username that started the process | Yes |
| amount | decimal | Transaction Amount | Yes |
| type | string | Transaction Type | Yes |
| external_transaction_id | string | Unique ID submitted by the site | No |

<h3>Example PHP Code</h3>

If an external_transaction_id is sent when you start the transaction, it must be added.

```php
$parameters = [
    'api_id' => 1,
    'api_key' => 'x3dfjkasdo12332',
    'user_id' => 1,
    'username' => 'pay_test',
    'amount' => 200.5,
    'type' => 'withdraw', // example: deposit or withdraw
    'external_transaction_id' => '5f08479c847733826ad5e4c1'
];

$generateHash = hash("sha512", http_build_query($parameters));

echo $generateHash;
```

<h3>Example C# Code</h3>

If an external_transaction_id is sent when you start the transaction, it must be added.

```php
public class paymentHash
{
    public string api_id { get; set; }
    public string api_key { get; set; }
    public string user_id { get; set; }
    public string username { get; set; }
    public string amount { get; set; }
    public string type { get; set; }
    public string external_transaction_id { get; set; }
}

var hashObj = new paymentHash()
{
    api_id = 1,
    api_key = 'x3dfjkasdo12332',
    user_id = 1,
    username = 'pay_test',
    amount = 200.5,
    type = 'withdraw', // example: deposit or withdraw
    external_transaction_id= '5f08479c847733826ad5e4c1'
};

var properties = from p in hashObj.GetType().GetProperties()
                 where p.GetValue(hashObj, null) != null
                 select p.Name + "=" + HttpUtility.UrlEncode(p.GetValue(hashObj, null).ToString());
             
string queryString = String.Join("&", properties.ToArray());

string hash = BitConverter.ToString(new SHA512CryptoServiceProvider().ComputeHash(Encoding.Default.GetBytes(queryString))).Replace("-", String.Empty).ToLower();
```

<h3>Example JavaScript Code</h3>

If an external_transaction_id is sent when you start the transaction, it must be added.

```javascript
function sha512(str) {
  return crypto.subtle.digest("SHA-512", new TextEncoder("utf-8").encode(str)).then(buf => {
    return Array.prototype.map.call(new Uint8Array(buf), x=>(('00'+x.toString(16)).slice(-2))).join('');
  });
}

var params = {
    api_id: 1,
    api_key: 'x3dfjkasdo12332',
    user_id: 1,
    username: 'pay_test',
    amount: 200.5,
    type: 'withdraw', // example: deposit or withdraw
    external_transaction_id: '5f08479c847733826ad5e4c1'
};

var esc = encodeURIComponent;
var query = Object.keys(params)
    .map(k => esc(k) + '=' + esc(params[k]))
    .join('&');

sha512(query).then(x => console.log(x));
    
console.log(query);
```
