<?php
/**
 * Created by PhpStorm.
 * Filename: SxTransaction.php
 * Description:
 * User: orhanbhr
 * Date: 11.09.2023
 * Time: 06:38
 */

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class SxTransaction extends Model
{
    protected $table = 'sx_transactions';

    /**
     * @param $senderName
     * @param $amount
     * @param $receiverAccountNumber
     * @param $receiverAccountName
     * @param $currency
     * @param $isInterruption
     * @param $description
     * @param $isHiddenName
     * @return int
     */
    public static function addTransaction(
        $senderName,
        $amount,
        $receiverAccountNumber,
        $receiverAccountName,
        $currency,
        $isInterruption,
        $description,
        $isHiddenName
    ): int
    {
        return self::query()
            ->insertGetId([
                'transaction_id' => 0,
                'sender_name' => $senderName,
                'amount' => $amount,
                'receiver_account_number' => $receiverAccountNumber,
                'receiver_account_name' => $receiverAccountName,
                'currency' => $currency,
                'status' => 0,
                'is_interruption' => $isInterruption,
                'is_hidden_name' => $isHiddenName,
                'description' => $description,
                'internal_bank_account_id' => 0,
                'user_id' => 0,
                'is_approved' => 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]);
    }

    /**
     * @param $id
     * @param $bankAccountId
     * @return int
     */
    public static function updateBankAccountId($id, $bankAccountId): int
    {
        return self::query()
            ->where('id', $id)
            ->update([
                'internal_bank_account_id' => $bankAccountId,
                'updated_at' => Carbon::now()
            ]);
    }
}
