<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class SxLog extends Model
{
    protected $table = 'sx_logs';

    /**
     * @param $chatId
     * @param $content
     * @return bool
     */
    public static function addLog(
        $chatId,
        $content
    ): bool
    {
        return self::query()
            ->insert([
                'chat_id' => $chatId ?? 0,
                'content' => json_encode($content ?? []),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]);
    }
}
