<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Jenssegers\Agent\Agent;

class Log extends Model
{
    protected $table = 'logs';

    private static $typeList = [
        1 => 'Profilini Düzenledi.',
        2 => 'Genel Ayarları Düzenledi.',
        3 => 'Ödeme Yöntemi Düzenledi.',
        4 => 'Oyuncu Bilgileri Düzenledi.',
        5 => 'Sistemden Çıkış Yapıldı.',
        6 => 'Sisteme Giriş Yapıldı.',
        7 => 'Manuel Talep Oluşturuldu.',
        8 => 'Talep Manuel Olarak Düzenlendi.',
        9 => 'Talep Operatör Tarafından İşlem Yapıldı.',
        10 => 'Talep için Otomatik İşlem Yapıldı.',
        11 => 'Tanımlanan IP Adresi Eklendi.',
        12 => 'Tanımlanan IP Adresi Düzenlendi.',
        13 => 'Site Eklendi.',
        14 => 'Site Düzenlendi.',
        15 => 'Operatör Eklendi.',
        16 => 'Operatör Düzenlendi.',
        17 => 'Banka Eklendi.',
        18 => 'Banka Düzenlendi.',
        19 => 'Yatırım Aralığı Eklendi.',
        20 => 'Yatırım Aralığı Düzenlendi.',
        21 => 'Hesap Eklendi.',
        22 => 'Hesap Düzenlendi.',
        23 => 'Hesap Durumu Düzenlendi.',
        24 => 'Site Komisyonu Eklendi.',
        25 => 'Site Komisyonu Düzenlendi.',
        26 => 'PushBullet Mesajı Silindi.',
        27 => 'PushBullet Mesajı Okundu.',
        28 => 'Doğrulama Girişi Yapıldı.',
        29 => 'Doğrulama Girişi Kaldırıldı.',
        30 => 'Doğrulama Girişi Eklendi.',
        31 => 'Talep Silindi.',
        32 => 'Talep Sinirken Hata Oluştu.',
        33 => 'Banka Hesabı Eşleştirildi.',
        34 => 'Banka Hesabı Eşleştirilemedi.',
        35 => 'Talep için İşlem Yapıldı.'
    ];

    /**
     * @param $processId
     * @return string
     */
    public static function getProcessType($processId)
    {
        switch ($processId) {
            case 1:
                return 'Site';
                break;

            case 2:
                return 'Oyuncu';
                break;

            case 3:
                return 'Ödeme Yöntemi';
                break;

            case 4:
                return 'Talep/İşlem';
                break;

            case 5:
                return 'IP Adresi';
                break;

            case 6:
                return 'Operatör';
                break;

            case 7:
                return 'Banka';
                break;

            case 8:
                return 'Yatırım Aralığı';
                break;

            case 9:
                return 'Hesap';
                break;

            case 10:
                return 'PushBullet';
                break;

            case 11:
                return 'Google Authenticator';
                break;

            case 12:
                return 'Saklanax';
                break;

            default:
                return '-';
                break;
        }
    }

    /**
     * @param $typeId
     * @return string
     */
    public static function getType($typeId)
    {
        if (!empty($typeId) && !empty(self::$typeList[$typeId])) {
            return self::$typeList[$typeId];
        } else {
            return '-';
        }
    }

    /**
     * @return array
     */
    public static function getTypeList()
    {
        return self::$typeList;
    }

    /**
     * @return BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * @param $userId
     * @param $typeId
     * @param int $processType
     * @param int $processId
     * @return mixed
     */
    public static function addLog($userId, $typeId, $processType = 0, $processId = 0)
    {
        $agent = new Agent();

        return self::insert([
            'user_id' => $userId,
            'type_id' => $typeId,
            'ip_address' => self::getIpAddress(),
            'process_type' => $processType,
            'process_id' => $processId,
            'browser' => $agent->browser(),
            'operation_system' => $agent->platform(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }

    /**
     * @return array|false|string
     */
    private static function getIpAddress()
    {
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } else if (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
            if (strstr($ip, ',')) {
                $tmp = explode (',', $ip);
                $ip = trim($tmp[0]);
            }
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        return $ip;
    }
}
