<?php if(count($bankAccounts) > 0): ?>
    <?php $__currentLoopData = $bankAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($account->id); ?></td>
            <td>
                <?php if(!empty($account->api_id)): ?>
                    <?php
                        $explode = explode(',', $account->api_id);
                    ?>

                    <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#accountListModal_<?php echo e($account->id); ?>">
                        Siteleri Gör
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="accountListModal_<?php echo e($account->id); ?>" tabindex="-1" aria-labelledby="accountListModal_<?php echo e($account->id); ?>_Label" aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">
                                        #<?php echo e($account->id); ?> (<?php echo e($account->account_owner); ?>) Hesabına Tanımlanmış Siteler
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-bordered table-hover">
                                        <tbody>
                                            <?php $__currentLoopData = $explode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($sites[$value]['name'] ?? '-'); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    Hepsi
                <?php endif; ?>
            </td>
            <td><?php echo e(\App\BankAccount::getType($account->type_id)); ?></td>
            <td><?php echo e(!empty($account->bank_name) ? $account->bank_name : '-'); ?></td>
            <td><?php echo e($account->is_pp_iban == 1 ? 'Evet' : 'Hayır'); ?></td>
            <td><?php echo e($account->account_owner); ?></td>
            <td><?php echo e($account->account_number); ?></td>
            <!--<td><?php echo e($account->branch_code); ?></td>
            <td><?php echo e($account->iban); ?></td>-->
            <?php if($account->status == 1): ?>
                <td>
                    <?php echo e(\App\Transaction::getCountDepositByBankAccountId($account->id, $account->created_at)); ?>

                </td>
                <td>
                    <?php echo e(\App\Transaction::getCountDrawByBankAccountId($account->id, $account->created_at)); ?>

                </td>
            <?php else: ?>
                <td>-</td>
                <td>-</td>
            <?php endif; ?>
            <td><?php echo e($account->balance); ?></td>
            <td><?php echo e($account->description); ?></td>
            <td><?php echo e(!empty($account['deposit_range']) ? $account->deposit_range->name : '-'); ?></td>
            <td>
                <?php if($account->status == 1): ?>
                    <span class="badge text-white bg-green">Aktif</span>
                <?php elseif($account->status == 2): ?>
                    <span class="badge text-white bg-dark">Kullanım Dışı</span>
                <?php else: ?>
                    <span class="badge text-white bg-red">Pasif</span>
                <?php endif; ?>
            </td>
            <td><?php echo e($account->updated_at); ?></td>
            <td style="width: 175px;">
                <a href="<?php echo e(url('/admin/account-management/accounts/edit/' . $account->id)); ?>" class="btn btn-sm btn-warning">
                    <i class="icon-pencil"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('<?php echo e($account->id); ?>', '0', '<?php echo e($account->status == 2 ? 1 : 0); ?>')" class="btn btn-sm btn-danger">
                    <i class="icon-times"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('<?php echo e($account->id); ?>', '1', '<?php echo e($account->status == 2 ? 1 : 0); ?>')" class="btn btn-sm btn-success">
                    <i class="icon-check"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('<?php echo e($account->id); ?>', '2', '<?php echo e($account->status == 2 ? 1 : 0); ?>')" class="btn btn-sm btn-dark">
                    <i class="icon-trash"></i>
                </a>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <tr>
        <td colspan="13">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
<?php endif; ?>

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '<?php echo e($bankAccounts->total()); ?>',
        perPage: '<?php echo e($bankAccounts->perPage()); ?>',
        currentPage: '<?php echo e($bankAccounts->currentPage()); ?>',
    };
</script>
<?php /**PATH /home/ssodeme/public_html/resources/views/panel/account_list.blade.php ENDPATH**/ ?>