@if(count($transactions) > 0)
    @php
        $totalData = [
            'deposit' => 0,
            'deposit_piece' => 0,
            'deposit_commission' => 0,
            'withdraw' => 0,
            'withdraw_piece' => 0,
            'withdraw_commission' => 0
        ];
    @endphp
    @foreach($transactions as $site)
        @foreach($site as $transaction)
            @php
                $totalData['deposit'] += $transaction['counts']['deposit']['amount'];
                $totalData['deposit_piece'] += $transaction['counts']['deposit']['piece'];
                $totalData['deposit_commission'] += $transaction['counts']['deposit']['commission_amount'];
                $totalData['withdraw'] += $transaction['counts']['withdraw']['amount'];
                $totalData['withdraw_piece'] += $transaction['counts']['withdraw']['piece'];
                $totalData['withdraw_commission'] += $transaction['counts']['withdraw']['commission_amount'];
            @endphp
            <tr>
                <td>{{ $transaction['api']['name'] }}</td>
                <td>{{ $transaction['paymentMethod']['name'] }}</td>
                <td>{{ number_format($transaction['counts']['deposit']['amount'], 2) }}</td>
                <td>{{ $transaction['counts']['deposit']['piece'] }}</td>
                <td>{{ number_format($transaction['counts']['deposit']['commission_amount'], 2) }} <span style="float: right">(%{{ $transaction['counts']['deposit']['commission'] }})</span></td>
                <td>{{ number_format($transaction['counts']['withdraw']['amount'], 2) }}</td>
                <td>{{ $transaction['counts']['withdraw']['piece'] }}</td>
                <td>{{ number_format($transaction['counts']['withdraw']['commission_amount'], 2) }} <span style="float: right">(%{{ $transaction['counts']['withdraw']['commission'] }})</span></td>
                <td>{{ number_format($transaction['counts']['deposit']['amount'] - $transaction['counts']['withdraw']['amount'], 2) }}</td>
            </tr>
        @endforeach
    @endforeach
    <tr style="background: #3ebf3e;color: #fff;">
        <td colspan="2">TOPLAM</td>
        <td>{{ number_format($totalData['deposit'], 2) }}</td>
        <td>{{ $totalData['deposit_piece'] }}</td>
        <td>{{ number_format($totalData['deposit_commission'], 2) }}</td>
        <td>{{ number_format($totalData['withdraw'], 2) }}</td>
        <td>{{ $totalData['withdraw_piece'] }}</td>
        <td>{{ number_format($totalData['withdraw_commission'], 2) }}</td>
        <td>{{ number_format($totalData['deposit'] - $totalData['withdraw'], 2) }}</td>
    </tr>
    <tr>
        <td colspan="9">Görüntülediğiniz Rapor {{ $startDate }} ile {{ $endDate }} arasını göstermektedir.</td>
    </tr>
@else
    <tr>
        <td colspan="9">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif
