@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="animatedParent animateOnce">
            <div class="container-fluid my-3">
                <div class="row">
                    @if($message = Session::get('error'))
                    <div class="col-md-12">
                        <div class="alert alert-danger alert-block">
                            <button type="button" class="close" data-dismiss="alert">×</button>
                            <strong>{{ $message }}</strong>
                        </div>
                    </div>
                    @endif

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body b-b">
                                <form method="POST" action="">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                                    @if($user->ga_status == 1)
                                        <a href="{{ url('/admin/g2a/disable') }}" class="btn btn-xl btn-dark">
                                            <i class="icon-google"></i> Google Authenticator kapatmak için lütfen tıklayınız !
                                        </a>
                                    @else
                                        <div class="form-group">
                                            <label class="col-form-label">Hesabıma Tanımlanacak Olan QR Kodu:</label>

                                            <br />
                                            <br />

                                            <img src="{{ $qrCodeUrl }}" />
                                        </div>

                                        <div class="form-group">
                                            <label for="account_name" class="col-form-label">Hesap</label>
                                            <input type="text" class="form-control" id="account_name" value="{{ $accountName }}" disabled>
                                        </div>

                                        <div class="form-group">
                                            <label for="secret" class="col-form-label">Anahtar</label>
                                            <input type="text" class="form-control" id="secret" value="{{ $accountSecret }}" disabled>
                                        </div>

                                        <button type="submit" class="btn btn-success">Google Authenticator'u Aktif Et</button>
                                    @endif
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('panel.includes.footer')
