@if(count($bankAccounts) > 0)
    @foreach($bankAccounts as $account)
        <tr>
            <td>{{ $account->id }}</td>
            <td>
                @if(!empty($account->api_id))
                    @php
                        $explode = explode(',', $account->api_id);
                    @endphp

                    <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#accountListModal_{{ $account->id }}">
                        Siteleri Gör
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="accountListModal_{{ $account->id }}" tabindex="-1" aria-labelledby="accountListModal_{{ $account->id }}_Label" aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">
                                        #{{ $account->id }} ({{ $account->account_owner }}) Hesabına Tanımlanmış Siteler
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-bordered table-hover">
                                        <tbody>
                                            @foreach($explode as $key => $value)
                                                <tr>
                                                    <td>{{ $sites[$value]['name'] ?? '-' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    Hepsi
                @endif
            </td>
            <td>{{ \App\BankAccount::getType($account->type_id) }}</td>
            <td>{{ !empty($account->bank_name) ? $account->bank_name : '-' }}</td>
            <td>{{ $account->is_pp_iban == 1 ? 'Evet' : 'Hayır' }}</td>
            <td>{{ $account->account_owner }}</td>
            <td>{{ $account->account_number }}</td>
            <!--<td>{{ $account->branch_code }}</td>
            <td>{{ $account->iban }}</td>-->
            @if($account->status == 1)
                <td>
                    {{ \App\Transaction::getCountDepositByBankAccountId($account->id, $account->created_at) }}
                </td>
                <td>
                    {{ \App\Transaction::getCountDrawByBankAccountId($account->id, $account->created_at) }}
                </td>
            @else
                <td>-</td>
                <td>-</td>
            @endif
            <td>{{ $account->balance }}</td>
            <td>{{ $account->description }}</td>
            <td>{{ !empty($account['deposit_range']) ? $account->deposit_range->name : '-' }}</td>
            <td>
                @if($account->status == 1)
                    <span class="badge text-white bg-green">Aktif</span>
                @elseif($account->status == 2)
                    <span class="badge text-white bg-dark">Kullanım Dışı</span>
                @else
                    <span class="badge text-white bg-red">Pasif</span>
                @endif
            </td>
            <td>{{ $account->updated_at }}</td>
            <td style="width: 175px;">
                <a href="{{ url('/admin/account-management/accounts/edit/' . $account->id) }}" class="btn btn-sm btn-warning">
                    <i class="icon-pencil"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('{{ $account->id }}', '0', '{{ $account->status == 2 ? 1 : 0 }}')" class="btn btn-sm btn-danger">
                    <i class="icon-times"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('{{ $account->id }}', '1', '{{ $account->status == 2 ? 1 : 0 }}')" class="btn btn-sm btn-success">
                    <i class="icon-check"></i>
                </a>
                <a href="javascript:void(0);" onclick="setAccountStatus('{{ $account->id }}', '2', '{{ $account->status == 2 ? 1 : 0 }}')" class="btn btn-sm btn-dark">
                    <i class="icon-trash"></i>
                </a>
            </td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="13">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '{{ $bankAccounts->total() }}',
        perPage: '{{ $bankAccounts->perPage() }}',
        currentPage: '{{ $bankAccounts->currentPage() }}',
    };
</script>
