<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Jekyll v3.8.5">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Payment Lobby</title>
    <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/css/fontawesome.min.css" rel="stylesheet">
</head>
<body>
    <div class="{{ request()->input('container') == 1 ? 'container' : '' }}" style="padding: 20px;">
        @if($errorPage)
            <div class="panel-home">
                <div class="panel-content">
                    <div class="payment-logo" style="text-align: center;margin-top: 50px;">
                        <img src="/assets/img/error.png">
                    </div>
                    <div class="payment-error-text" style="text-align: center;margin-top: 50px;font-size: 20px;">Böyle Bir Ödeme Sayfası ya da Ödeme Yöntemi Bulunamadı. Lütfen firmanız ile iletişime geçiniz.</div>
                </div>
            </div>
        @else
            @foreach($paymentMethods as $method)
            <div class="page-deposit-list-item">
                <div class="page-deposit-list-item-title" onclick="openPaymentMethod({{ $method->id }})">
                    <div class="icon">
                        <img alt="{{ $method->name }}" src="{{ $method->logo }}">
                    </div>
                    <table>
                        <thead>
                        <tr><th>{{ $method->name }}</th>
                            <th>İşlem Ücreti</th>
                            <th>İşlem Zamanı</th>
                            <th>Limiti</th>
                        </tr></thead>
                        <tbody>
                        <tr>
                            <td>{{ $type == 1 ? 'ile Para Yatırma' : 'ile Para Çekme' }}</td>
                            <td>{{ $method->fee == 0 ? 'Ücretsiz' : $method->fee }}</td>
                            <td>{{ $method->time }}</td>
                            <td>
                                <span>Min. TRY: {{ $method->min_amount }}</span>
                                <span>Max. TRY: {{ $method->max_amount }}</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    <div class="page-deposit-list-item-title-caret">
                        <img src="/assets/img/down-chevron-2.svg">
                    </div>
                </div>
                <div class="page-deposit-list-item-content page-deposit-list-item-content-shows payment-method-detail-url" id="paymentMethodUrl-{{ $method->id }}" style="display: none;">
                    <iframe allow="autoplay" allowfullscreen="" id="paymentUrl-{{ $method->id }}" src="" style="width: 100%;border: 0;height: {{ $method->id == 6 ? '750px' : '1500px' }};"></iframe>
                </div>
                <div class="page-deposit-list-item-content page-deposit-list-item-content-shows payment-method-detail" id="paymentMethodDetail-{{ $method->id }}" style="display: none;">
                    <div class="account-details" style="display: none;">
                        <!-- loading... -->
                    </div>
                    <div class="errors" style="display: none;">
                        <!-- loading... -->
                    </div>
                    <form data-type="POST" data-url="/api/payment/create" enctype="multipart/form-data" id="formDetail-{{ $method->id }}">
                        <input type="hidden" name="method_id" value="{{ $method->id }}">
                        <input type="hidden" name="api_id" value="{{ $site->id }}">
                        <input type="hidden" name="player_id" value="{{ $player->id }}">
                        <input type="hidden" name="external_transaction_id" value="{{ !empty($externalTransactionId) ? $externalTransactionId : '' }}">
                        <!--<input type="hidden" name="bank_account_id" value="0">-->
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">

                        @if($method->id == 12)
                        <div class="form-group">
                            <a class="btn btn-warning" href="//www.payturka.com/?hash=94c6f2f029c9adb96d313b50f92885e8" target="_blank">Hızlı ve Güvenli Cmt Yatırımı için Tıklayın</a>
                        </div>

                        <div class="form-group">
                            <span style="color: red;">Not: Cmt Yatırımı Yaptıktan Sonra Talep Oluşturmayı Unutmayınız !</span>
                        </div>
                        @endif

                        @if($method->id == 15)
                        <div class="form-group">
                            <a class="btn btn-warning" href="//redin.club/Pays/4421333" target="_blank">Hızlı ve Güvenli Kredi Kartı Yatırımı için Tıklayın</a>
                        </div>

                        <div class="form-group">
                            <span style="color: red;">Not: Kredi Kartı Yatırımı Yaptıktan Sonra Talep Oluşturmayı Unutmayınız !</span><br />
                            <span style="color: red;">- Aynı Karttan Ay İçinde Maximum 5000 TL Ödeme Yapabilirsiniz</span><br />
                            <span style="color: red;">- Ödeme Yaparken İşlem Bitmeden Ekranı Kapatmayınız, Telefon Onayı Gerekebilir.</span><br />
                            <span style="color: red;">- Kişisel Bilgilerinizi Doğru Giriniz.</span><br />
                            <span style="color: red;">- Min 20, Max 750 TL Yatırım Yapabilirsiniz.</span>
                        </div>
                        @endif

                        @if($method->id == 1)
                            <div class="form-group">
                                <label for="_bankdraw">Banka Seçiniz</label>
                                <select class="form-control" id="_bankdraw" name="bank_id">
                                    <option value="">Seçiniz</option>
                                    @foreach($banks as $bank)
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif

                        @if($method->id == 1)
                            <div class="form-group">
                                <label for="process_account_name">Yatırım Yapılan Hesap Adı</label>
                                <input type="text" id="process_account_name" class="form-control" name="process_account_name">
                                <span style="color: darkred">Lütfen yatırım yapmış olduğunuz hesap adını giriniz, kendi hesap adınızı girmeyiniz.</span>
                            </div>
                            <!--<div class="form-group">
                                <label for="_bankdraw">Banka Seçiniz</label>
                                <select class="form-control" id="bank_account_list_load" name="bank_account_id">
                                    <option value="">Seçiniz</option>
                                </select>
                            </div>-->
                        @endif

                        @if($method->id == 1)
                            <div class="form-group">
                                <label for="_transaction_date">İşlem Tarihi</label>
                                <input type="datetime-local" id="_transaction_date" class="form-control" name="transaction_date" value="{{ date('Y-m-d') }}T{{ date('H:i') }}">
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="form-group">
                                <label for="_bankdraw">Banka Seçiniz</label>
                                <select class="form-control" id="bank" name="bank_id">
                                    <option value="">Seçiniz</option>
                                    @foreach($banks as $bank)
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif

                        @if(
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 7 ||
                            $method->id == 8 ||
                            $method->id == 12
                        )
                            <div class="form-group">
                                <label for="_account_number">Hesap Numarası</label>
                                <input type="text" id="_account_number" class="form-control" name="account_number">
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="form-group">
                                <label for="_iban">IBAN</label>
                                <input type="text" id="_iban" class="form-control" name="iban">
                            </div>
                        @endif

                        @if($method->id == 7)
                            <div class="form-group">
                                <label for="_branch_code">Şube Kodu</label>
                                <input type="text" id="_branch_code" class="form-control" name="branch_code">
                            </div>
                        @endif

                        @if(
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 7 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                            <div class="form-group">
                                <label for="_firstname_and_lastname">İsim ve Soyisim</label>
                                <input type="text" id="_firstname_and_lastname" class="form-control" name="firstname_and_lastname">
                            </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 12
                        )
                            <div class="form-group">
                                <label for="_identity_number">Kimlik Numarası</label>
                                <input type="text" id="_identity_number" class="form-control" name="identity_number">
                            </div>
                        @endif

                        @if(
                            $method->id == 6 ||
                            $method->id == 11
                        )
                            <div class="form-group">
                                <label for="_wallet_code">Cüzdan Kodu</label>
                                <input type="text" id="_wallet_code" class="form-control" name="wallet_code">
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_cepbank">Banka Seçiniz</label>
                                <select class="form-control" id="bank" name="bank_id">
                                    <option value="">Seçiniz</option>
                                    @foreach($mobileBanks as $bank)
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_sender_phone_number">Gönderici Telefon Numarası</label>
                                <input type="text" id="_sender_phone_number" class="form-control" name="sender_phone_number">
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_receiver_phone_number">Alıcı Telefon Numarası</label>
                                <input type="text" id="_receiver_phone_number" class="form-control" name="receiver_phone_number">
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_password">Şifre</label>
                                <input type="text" id="_password" class="form-control" name="password">
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="identity_date">Veriliş/Geçerlilik Tarihi</label>
                                <input type="text" id="identity_date" class="form-control" name="identity_date">
                                <span style="color: red">Eski Kimlik ise Veriliş, Yeni Kimlik ise Geçerlilik Tarihi Giriniz !</span>
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_receiver_identity_number">Alıcı Kimlik Numarası</label>
                                <input type="text" id="_receiver_identity_number" class="form-control" name="receiver_identity_number">
                            </div>
                        @endif

                        @if($method->id == 2)
                            <div class="form-group">
                                <label for="_receiver_birth_date">Alıcı Doğum Tarihi</label>
                                <input type="date" id="_receiver_birth_date" class="form-control" name="receiver_birth_date">
                            </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 2 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                            <div class="form-group">
                                <label for="_customer_note">Kullanıcı Notu (İsteğe Bağlı)</label>
                                <input type="text" id="_customer_note" class="form-control" name="customer_note">
                            </div>
                        @endif

                        @if(
                            $method->id == 1 ||
                            $method->id == 2 ||
                            $method->id == 3 ||
                            $method->id == 4 ||
                            $method->id == 5 ||
                            $method->id == 6 ||
                            $method->id == 7 ||
                            $method->id == 8 ||
                            $method->id == 9 ||
                            $method->id == 10 ||
                            $method->id == 11 ||
                            $method->id == 12 ||
                            $method->id == 15
                        )
                            <div class="form-group">
                                <label for="_amount">Miktar</label>
                                <input type="text" id="_amount" class="form-control" name="amount">
                            </div>
                        @endif

                        <div class="form-group">
                            <button class="btn btn-primary" id="createPayment" type="button">Talep Gönder</button>
                        </div>
                    </form>
                </div>
            </div>
            @endforeach
        @endif
    </div>

    <style>
        .page-deposit-list-item {
            float: left;
            width: 100%;
            border-radius: 5px;
            background: #fff;
            box-shadow: 0px 0px 33px 2px rgba(0,0,0,0.05);
            margin-top: 20px;
            font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
            font-size: 14px;
        }
        .page-deposit-list-item .page-deposit-list-item-title {
            float: left;
            width: 100%;
            padding: 10px 0;
            cursor: pointer;
        }
        .page-deposit-list-item .page-deposit-list-item-title .icon {
            float: left;
            width: 40px;
            height: 40px;
            overflow: hidden;
            margin: 20px;
        }
        .page-deposit-list-item .page-deposit-list-item-title .icon img {
            max-width: 100%;
        }
        .page-deposit-list-item .page-deposit-list-item-title table {
            float: left;
            width: 80%;
            margin-top: 15px;
        }
        .page-deposit-list-item .page-deposit-list-item-title table thead th {
            width: 25%;
            color: #101028;
        }
        .page-deposit-list-item .page-deposit-list-item-title table tbody td {
            color: #101028;
        }
        .page-deposit-list-item .page-deposit-list-item-title table tbody td span {
            width: 100%;
            float: left;
        }
        .page-deposit-list-item .page-deposit-list-item-title .page-deposit-list-item-title-caret {
            float: right;
            width: 35px;
            overflow: hidden;
            margin-right: 29px;
            margin-top: 26px;
        }
        .page-deposit-list-item .page-deposit-list-item-title .page-deposit-list-item-title-caret img {
            max-width: 100%;
        }
        .page-deposit-list-item .page-deposit-list-item-content {
            float: left;
            width: 100%;
            padding: 20px;
            border-top: 1px solid #ddd;
            display: none;
        }
        .account-details {
            width: 100%;
            display: inline-block;
            background: #e9f969;
            padding: 20px;
            position: relative;
            margin-bottom: 20px;
        }
        .account-detail-title {
            width: 100%;
            font-size: 18px;
        }
        .account-detail-content {
            width: 100%;
            margin-top: 10px;
        }
        .account-detail-content span {
            width: 100%;
            display: inline-block;
        }
        .copy-btn {
            width: 100px;
            position: absolute;
            float: right;
            right: 0;
            top: 0;
            background: #ca2020;
            color: #fff;
            text-align: center;
            text-decoration: none;
            height: 40px;
            line-height: 40px;
        }
        .copy-btn:hover {
            color: #eee;
            text-decoration: none;
        }
        .errors {
            width: 100%;
            display: inline-block;
        }
    </style>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"
            integrity="sha384-xrRywqdh3PHs8keKZN+8zzc5TX0GRTLCcmivcbNJWm2rs5C8PRhcEn3czEjhAO9o"
            crossorigin="anonymous"></script>
    <script src="/assets/js/app.js"></script>

    @if(!empty(request()->input('method')))
        <script>
            $(function () {
                openPaymentMethod({{ request()->input('method') }});
            });
        </script>
    @endif
</body>
</html>
