<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Jekyll v3.8.5">
    <title>Payment Lobby</title>
    <link href="/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="/assets/css/fontawesome.min.css" rel="stylesheet">
    <link href="/assets/css/app.css" rel="stylesheet">
</head>
<body>
    <div class="{{ request()->input('container') == 1 ? 'container' : '' }}">
        @if($errorPage)
            <div class="panel-home">
                <div class="panel-content">
                    <div class="payment-logo">
                        <img src="/assets/img/error.png">
                    </div>
                    <div class="payment-error-text">Böyle Bir Ödeme Sayfası ya da Ödeme Yöntemi Bulunamadı. Lütfen firmanız ile iletişime geçiniz.</div>
                </div>
            </div>
        @else
            <div class="tablo-list">
                <div class="tablo-one">
                    @foreach($paymentMethods as $method)
                    <table>
                        <tbody>
                        <tr>
                            <td colspan="2">
                                <img alt="{{ $method->name }}" src="{{ $method->logo }}">
                            </td>
                        </tr>
                        <tr>
                            <td>Yöntem</td>
                            <td>{{ $method->name }}</td>
                        </tr>
                        <tr>
                            <td>Işlem Limiti</td>
                            <td>
                                <span style="width: 100%;display: block;height: 20px;">Min: {{ $method->min_amount }} TL</span>
                                <span style="width: 100%;display: block;">Max: {{ $method->max_amount }} TL</span>
                            </td>
                        </tr>
                        <tr>
                            <td>Işlem Ücreti</td>
                            <td>{{ $method->fee == 0 ? 'Ücretsiz' : $method->fee }}</td>
                        </tr>
                        <tr>
                            <td>Süre</td>
                            <td>{{ $method->time }}</td>
                        </tr>
                        @if($type == 1)
                        <tr>
                            <td>Nakit Bonus</td>
                            <td>{{ $method->cash_bonus }}</td>
                        </tr>
                        @endif
                        <tr>
                            <td colspan="2">
                                <a class="plus-btn" href="{{ url('/payment/page/' . $method->id . '?api_id=' . $site->id . '&player_id=' . $player->id . '&mobile=' . $mobile) }}">
                                    <i class="fas fa-plus"></i>
                                    SEÇ
                                </a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    @endforeach
                </div>
            </div>
        @endif
    </div>

    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"
            integrity="sha384-xrRywqdh3PHs8keKZN+8zzc5TX0GRTLCcmivcbNJWm2rs5C8PRhcEn3czEjhAO9o"
            crossorigin="anonymous"></script>
    <script src="/assets/js/app.js"></script>
</body>
</html>
