<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;

class WhiteListIp extends Model
{
    protected $table = 'whitelist_ip';

    /**
     * Gelen İsteklerin Hangi IP adresinden geldiğini öğreniyoruz.
     * @return array|false|string
     */
    public static function getIpAddress()
    {
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } elseif (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
            if (strstr($ip, ',')) {
                $tmp = explode(',', $ip);
                $ip = trim($tmp[0]);
            }
        } else {
            $ip = getenv("REMOTE_ADDR");
        }

        return $ip;
    }

    /**
     * Check IP Address Method
     * @return bool
     */
    public static function checkIpAddress()
    {
        $getIp = self::getIpAddress();
        $cacheKey = 'whiteListIp:' . md5($getIp);

        if (Cache::has($cacheKey)) {
            $ipDetail = Cache::get($cacheKey);

            if (!empty($ipDetail))
                return true;
            else
                return false;
        }

        $queryIpAddress = self::query()
            ->where('ip_address', $getIp)
            ->where('status', 1)
            ->first();

        if (!empty($queryIpAddress))
            return true;
        else
            return false;
    }
}
