<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SiteCommission extends Model
{
    protected $table = 'site_commissions';

    /**
     * @param $siteId
     * @param $paymentMethodId
     * @return int
     */
    public static function getCommission($siteId, $paymentMethodId)
    {
        $getQuery = self::where('site_id', $siteId)
            ->where('payment_method_id', $paymentMethodId)
            ->first();

        if (!empty($getQuery))
            return round($getQuery->percent / (100 / 100),2);
        else
            return 0;
    }
}
