<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Site extends Model
{
    protected $table = 'sites';

    /**
     * @param $platformId
     * @return string
     */
    public static function getPlatform($platformId): string
    {
        switch ($platformId) {
            case 1:
                return 'JoyBet';

            case 2:
                return 'BetConstruct';

            case 3:
                return 'Pronet Gaming';

            case 4:
                return 'BetWorkSpace';

            case 5:
                return 'BetAndWorks';

            case 6:
                return 'Rest/Pas';

            case 7:
                return 'BetModule';

            default:
                return 'Unknown';
        }
    }

    /**
     * @param $environmentId
     * @return string
     */
    public static function getEnvironment($environmentId)
    {
        switch ($environmentId) {
            case 1:
                return 'Production';
                break;

            case 2:
                return 'Test';
                break;

            default:
                return 'Unknown';
                break;
        }
    }
}
