<?php
/**
 * Created by PhpStorm.
 * Filename: IpLog.php
 * Description:
 * User: orhanbhr
 * Date: 21.11.2023
 * Time: 01:33
 */
namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Jenssegers\Agent\Agent;

class IpLog extends Model
{
    protected $table = 'ip_logs';

    public static function addLog($userId, $path)
    {
        return self::insert([
            'user_id' => $userId,
            'path' => $path,
            'ip_address' => self::getIpAddress(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }

    /**
     * @return array|false|string
     */
    private static function getIpAddress()
    {
        if (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        } else if (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
            if (strstr($ip, ',')) {
                $tmp = explode (',', $ip);
                $ip = trim($tmp[0]);
            }
        } else {
            $ip = getenv("REMOTE_ADDR");
        }
        return $ip;
    }
}
