<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Pushbullet\Pushbullet;

class PaymentController extends Controller
{
    public function getMaksiPara()
    {
        return view('maksipara');
    }

    public function getLobbyMaksi()
    {
        return view('lobby_maksipara');
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getLobby(Request $request)
    {
        /*if ($request->input('selam')) {
           echo JoyBetController::drawApproved(56757, 200, 'iptal test');

           die;
        }*/

        if ($request->input('selam')) {
            $json_url = "http://d.joybet203.com/datajson.php";
            $json = file_get_contents($json_url);
            $data = json_decode($json);

            foreach ($data as $key => $value) {
                $checkUser = Player::where('external_user_id', trim($value->ID))->where('username', trim($value->Username))->first();
                $explode = explode(' ', $value->Name);

                if (empty($checkUser)) {
                    Player::insert([
                        'api_id' => 1,
                        'username' => $value->Username,
                        'external_user_id' => $value->ID,
                        'external_password' => '',
                        'email' => $value->Email,
                        'first_name' => $explode[0],
                        'last_name' => str_replace($explode[0].' ', '', $value->Name),
                        'phone_number' => '',
                        'status' => 1
                    ]);
                    echo $value->Username.'-'.$value->ID.' eklendi.<br />';
                } else {
                    echo $value->Username.'-'.$value->ID.' güncellendi.<br />';
                }
            }

            die;
        }

        $errorPage = 0;
        $typeId = $request->input('type');
        $username = $request->input('username');
        $password = $request->input('password'); // for joybet platform
        $userId = $request->input('user_id');
        $apiId = $request->input('api_id');
        $firstName = $request->input('first_name');
        $lastName = $request->input('last_name');
        $email = $request->input('email');
        $phoneNumber = $request->input('phone_number');
        $container = $request->input('container');
        $balance = $request->input('balance');
        $mobile = $request->input('mobile');
        $method = $request->input('method');
        $externalTransactionId = $request->input('external_transaction_id');

        if (empty($apiId) && empty($userId) && empty($username))
            $errorPage = 1;

        $checkSite = Site::where('code', $apiId)->where('status', 1)->first();

        if (empty($checkSite))
            $errorPage = 1;

        $checkExternalTransaction = Transaction::where('external_transaction_id', $externalTransactionId)->count();

        if ($checkExternalTransaction > 0)
            $errorPage = 1;

        $checkPlayer = Player::where('api_id', $checkSite->id)
            ->where('username', $username)
            ->where('external_user_id', $userId)
            ->first();

        if (empty($checkPlayer)) {
            Player::insert([
                'api_id' => $checkSite->id,
                'username' => $username,
                'external_user_id' => $userId,
                'external_password' => $password,
                'email' => $email,
                'first_name' => $firstName,
                'last_name' => $lastName,
                'phone_number' => $phoneNumber,
                'status' => 1
            ]);

            $checkPlayerDetail = Player::where('api_id', $checkSite->id)
                ->where('username', $username)
                ->where('external_user_id', $userId)
                ->first();
        } else {
            Player::where('id', $checkPlayer->id)->update([
                'external_password' => $password
            ]);

            $checkPlayerDetail = $checkPlayer;
        }

        if (empty($checkPlayerDetail)) {
            $errorPage = 1;
        } else {
            if ($checkPlayerDetail->status != 1)
                $errorPage = 1;
        }

        $getPaymentMethods = new PaymentMethod();
        $getPaymentMethods = $getPaymentMethods->where('status', 1);
        $getPaymentMethods = $getPaymentMethods->where('type', $typeId);

        if (!empty($method))
            $getPaymentMethods = $getPaymentMethods->where('id', $method);

        $getPaymentMethods = $getPaymentMethods->get();

        if (empty($getPaymentMethods))
            $errorPage = 1;

        //$theme = ($checkSite->id == 1 ? 'joybet' : 'default');
        $theme = 'joybet';
        $getMobileBanks = Bank::where('status', 1)->where('mobile_bank', 1)->get();
        $getBanks = Bank::where('status', 1)->get();

        return view(!empty($mobile) && $mobile == 1 ? $theme . '_payment_lobby_mobile' : $theme . '_payment_lobby_web')
            ->with('type', $typeId)
            ->with('paymentMethods', $getPaymentMethods)
            ->with('errorPage', $errorPage)
            ->with('site', $checkSite)
            ->with('player', $checkPlayerDetail)
            ->with('container', $container)
            ->with('balance', $balance)
            ->with('mobile', !empty($mobile) ? 1 : 0)
            ->with('mobileBanks', $getMobileBanks)
            ->with('externalTransactionId', $externalTransactionId)
            ->with('banks', $getBanks);
    }
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function getPaymentSuccess(Request $request)
    {
        return view('payment_success');
    }

    /**
     * @param $methodId
     * @param Request $request
     * @return mixed
     */
    public function getPaymentPage($methodId, Request $request)
    {
        $apiId = $request->input('api_id');
        $apiKey = $request->input('api_key');
        $playerId = $request->input('player_id');
        $mobile = $request->input('mobile');
        $getSite = Site::where('id', $apiId)->first();
        $getPlayer = Player::where('id', $playerId)->first();
        $getPaymentMethod = PaymentMethod::where('id', $methodId)->first();
        $getBankAccounts = BankAccount::where('status', 1)->get();
        $getMobileBanks = Bank::where('status', 1)->where('mobile_bank', 1)->get();
        $getBanks = Bank::where('status', 1)->get();

        $theme = ($apiId == 1 ? 'joybet' : 'default');

        return view(!empty($mobile) && $mobile == 1 ? $theme . '_payment_page_mobile' : $theme . '_payment_page_web')
            ->with('paymentMethod', $getPaymentMethod)
            ->with('bankAccounts', $getBankAccounts)
            ->with('mobileBanks', $getMobileBanks)
            ->with('banks', $getBanks)
            ->with('methodId', $methodId)
            ->with('apiId', $apiId)
            ->with('site', $getSite)
            ->with('player', $getPlayer)
            ->with('playerId', $playerId);
    }

    /**
     * @param $typeId
     * @param $bankId
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountDetails($typeId, $bankId)
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");

        if (empty($typeId))
            return response()->json([
                'type' => 'error',
                'message' => 'Tip belirtilmedi.'
            ]);

        if ($typeId == 1 && empty($bankId))
            return response()->json([
                'type' => 'error',
                'message' => 'Hesap Bilgisi almak için lütfen banka seçiniz.'
            ]);

        if ($typeId == 9 && empty($bankId))
            return response()->json([
                'type' => 'error',
                'message' => 'Hesap Bilgisi almak için lütfen banka seçiniz.'
            ]);

        $getActiveBankAccounts = BankAccount::where('type_id', $typeId)
            ->where('status', 1)
            ->where('bank_id', (($typeId == 1 OR $typeId == 5) ? $bankId : 0))
            ->select(
                'id',
                'process_limit',
                'total_limit',
                'daily_limit'
            )
            ->get();

        if (empty($getActiveBankAccounts))
            return response()->json([
                'type' => 'error',
                'message' => 'Şu anda aktif hesap bilgisi bulunmamaktadır. Lütfen farklı bir yöntem ya da banka seçiniz.'
            ]);

        $activeBankId = 0;
        $dataBankAccounts = [];
        foreach ($getActiveBankAccounts as $bankAccount) {
            if (!empty($bankAccount->process_limit) && $bankAccount->process_limit > 0) {
                if ($bankAccount->process_limit > Transaction::getCountProcessLimit($bankAccount->id)) {
                    $dataBankAccounts[] = [
                        'id' => $bankAccount->id
                    ];
                }
            } else {
                if (
                    $bankAccount->total_limit > Transaction::getSumTotalLimit($bankAccount->id) &&
                    $bankAccount->daily_limit > Transaction::getSumDailyLimit($bankAccount->id)
                ) {
                    $dataBankAccounts[] = [
                        'id' => $bankAccount->id
                    ];
                }
            }
        }

        if (!empty($dataBankAccounts) && $dataBankAccounts > 0) {
            shuffle($dataBankAccounts);
            $activeBankId = $dataBankAccounts[0];
        }

        if (empty($activeBankId) || $activeBankId == 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Şu anda aktif hesap bilgisi bulunmamaktadır. Lütfen farklı bir yöntem ya da banka seçiniz.'
            ]);

        $findBankAccount = BankAccount::where('id', $activeBankId)->where('status', 1)->first();

        if (count($findBankAccount) > 0) {
            return response()->json([
                'type' => 'success',
                'message' => 'Banka hesabı getirildi.',
                'response' => [
                    'id' => $findBankAccount->id,
                    'bank_id' => $findBankAccount->bank_id,
                    'bank_name' => !empty($findBankAccount->bank_id) ? $findBankAccount->banks->name : null,
                    'account_number' => $findBankAccount->account_number,
                    'account_owner' => $findBankAccount->account_owner,
                    'branch_code' => $findBankAccount->branch_code,
                    'iban' => $findBankAccount->iban,
                    'description' => $findBankAccount->description,
                ]
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'message' => 'Şu anda aktif hesap bilgisi bulunmamaktadır. Lütfen farklı bir yöntem ya da banka seçiniz.'
            ]);
        }
    }

    /**
     * @param $bankId
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountsDetails($typeId)
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");

        if (empty($typeId))
            return response()->json([
                'type' => 'error',
                'message' => 'Tip belirtilmedi.'
            ]);


        $getActiveBankAccounts = BankAccount::where('type_id', $typeId)
            ->where('status', 1)
            ->select(
                'id',
                'process_limit',
                'total_limit',
                'daily_limit',
                'account_owner',
                'bank_id'
            )
            ->get();

        if (empty($getActiveBankAccounts))
            return response()->json([
                'type' => 'error',
                'message' => 'Şu anda aktif hesap bilgisi bulunmamaktadır. Lütfen farklı bir yöntem ya da banka seçiniz.'
            ]);

        $activeBankId = 0;
        $dataBankAccounts = [];
        foreach ($getActiveBankAccounts as $bankAccount) {
            if (!empty($bankAccount->process_limit) && $bankAccount->process_limit > 0) {
                if ($bankAccount->process_limit > Transaction::getCountProcessLimit($bankAccount->id)) {
                    $dataBankAccounts[] = [
                        'id' => $bankAccount->id,
                        'bank_name' => !empty($bankAccount->bank_id) ? Bank::getBankName($bankAccount->bank_id) : null,
                        'account_owner' => $bankAccount->account_owner,
                    ];
                }
            } else {
                if (
                    $bankAccount->total_limit > Transaction::getSumTotalLimit($bankAccount->id) &&
                    $bankAccount->daily_limit > Transaction::getSumDailyLimit($bankAccount->id)
                ) {
                    $dataBankAccounts[] = [
                        'id' => $bankAccount->id,
                        'bank_name' => !empty($bankAccount->bank_id) ? Bank::getBankName($bankAccount->bank_id) : null,
                        'account_owner' => $bankAccount->account_owner,
                    ];
                }
            }
        }

        /*if (!empty($dataBankAccounts) && $dataBankAccounts > 0) {
            shuffle($dataBankAccounts);
            $activeBankId = $dataBankAccounts[0];
        }

        if (empty($activeBankId) || $activeBankId == 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Şu anda aktif hesap bilgisi bulunmamaktadır. Lütfen farklı bir yöntem ya da banka seçiniz.'
            ]);

        $findBankAccount = BankAccount::where('id', $activeBankId)->where('status', 1)->first();*/

        return response()->json([
            'type' => 'success',
            'message' => 'Banka hesabı getirildi.',
            'response' => $dataBankAccounts
        ]);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function createPayment(Request $request)
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");

        $methodId = $request->input('method_id');
        $transactionPrice = $request->input('amount');
        $apiId = $request->input('api_id');
        $playerId = $request->input('player_id');
        $customerNote = $request->input('customer_note');
        $bankAccountId = $request->input('bank_account_id');
        $externalTransactionId = $request->input('external_transaction_id');

        if (
            empty($request->all()) ||
            empty($transactionPrice) ||
            empty($apiId) ||
            empty($playerId) ||
            empty($methodId)
        )
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, boş alan bırakmayınız.'
            ]);

        if ($methodId == 1 && empty($request->input('bank_id')))
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, banka seçiniz.'
            ]);

        if ($methodId == 7 && empty($request->input('bank_id')))
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, banka seçiniz.'
            ]);

        $checkApi = Site::where('id', $apiId)->first();

        if (empty($checkApi))
            return response()->json([
                'type' => 'error',
                'message' => 'Site bulunamadı, lütfen tekrar deneyiniz.'
            ]);

        $privateCode = time();
        $transactionData = [
            'api_id' => $apiId,
            'transaction_type' => $methodId,
            'bank_account_id' => !empty($bankAccountId) ? $bankAccountId : 0,
            'transaction_send_data' => json_encode($request->all()),
            'player_id' => $playerId,
            'amount' => $transactionPrice,
            'is_success' => 0,
            'user_id' => 0,
            'log_id' => $privateCode,
            'external_transaction_id' => $externalTransactionId,
            'customer_note' => $customerNote,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ];

        $checkPlayer = Player::where('id', $playerId)->first();

        if (empty($checkPlayer))
            return response()->json([
                'type' => 'error',
                'message' => 'Kullanıcı bulunamadı, lütfen tekrar deneyiniz.'
            ]);

        if (empty($checkPlayer->first_name) && empty($checkPlayer->last_name)) {
            if (!empty($request->input('firstname_and_lastname'))) {
                $firstAndLastName = explode(' ', $request->input('firstname_and_lastname'));

                Player::where('id', $checkPlayer->id)->update([
                    'first_name' => $firstAndLastName[0],
                    'last_name' => str_replace($firstAndLastName[0] . ' ', '', $request->input('firstname_and_lastname'))
                ]);
            }
        }

        $paymentMethod = PaymentMethod::where('status', 1)->where('id', $methodId)->first();

        if (empty($paymentMethod))
            return response()->json([
                'type' => 'error',
                'message' => 'Seçilen ödeme yöntemi aktif değildir.'
            ]);

        # check payment method max amount
        if ($transactionPrice > $paymentMethod->max_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Maximum Limit : ' . $paymentMethod->max_amount
            ]);

        # check payment method min amount
        if ($transactionPrice < $paymentMethod->min_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Minimum Limit : ' . $paymentMethod->min_amount
            ]);

        $getPaymentMethodIds = PaymentMethod::where('status', 1)->where('type', $paymentMethod->type)->get();
        $getPaymentMethodId = [];

        foreach ($getPaymentMethodIds as $key => $value) {
            $getPaymentMethodId[] = $value->id;
        }

        $checkTransaction = Transaction::where('api_id', $apiId)
            ->where('player_id', $playerId)
            ->where('is_success', 0)
            ->whereIn('transaction_type', $getPaymentMethodId)
            ->count();

        if ($checkTransaction > 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Aktif bekleyen talebiniz mevcut, lütfen aktif talebinizin sonuçlanmasını bekleyin.'
            ]);

        $checkTransaction2 = Transaction::where('api_id', $apiId)
            ->where('player_id', $playerId)
            ->where('is_success', 3)
            ->whereIn('transaction_type', $getPaymentMethodId)
            ->count();

        if ($checkTransaction2 > 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Aktif bekleyen talebiniz mevcut, lütfen aktif talebinizin sonuçlanmasını bekleyin.'
            ]);

        /*if ($paymentMethod->type == 2) {
            if ($checkApi->platform == 1) {
                $userBalance = JoyBetController::userBalance($checkPlayer->username, $checkPlayer->external_password);
            } else {
                $userBalance = 0;
            }

            if ($transactionPrice > $userBalance)
                return response()->json([
                    'type' => 'error',
                    'message' => 'Çekim Yapılabilir Bakiyeniz : ' . $userBalance . ' TL'
                ]);
        }*/

        $transactionId = Transaction::insertGetId($transactionData);

        if ($transactionId) {
            if ($paymentMethod->type == 2) {
                if ($checkApi->platform == 1) {
                    $drawAmount = JoyBetController::drawRequest(
                        $checkPlayer->username,
                        $checkPlayer->external_password,
                        $transactionPrice
                    );

                    /*if (!$drawAmount) {
                        Transaction::where('id', $transactionId)->update([
                            'is_success' => 2
                        ]);

                        return response()->json([
                            'type' => 'error',
                            'message' => 'Hesabınızdan bakiye düşülürken bir hata oluştu, lütfen tekrar deneyiniz.'
                        ]);
                    }*/

                    if (!empty($drawAmount)) {
                        Transaction::where('id', $transactionId)->update([
                            'is_success' => 2
                        ]);

                        return response()->json([
                            'type' => 'error',
                            'message' => $drawAmount
                        ]);
                    }
                } else {
                    Transaction::where('id', $transactionId)->update([
                        'is_success' => 2
                    ]);

                    return response()->json([
                        'type' => 'error',
                        'message' => 'Hesabınızdan bakiye düşülürken bir hata oluştu, lütfen tekrar deneyiniz.'
                    ]);
                }
            }

            if ($paymentMethod->id == 6) {
                $walletCode = $request->input('wallet_code');
                $apiUrl = 'https://walletapi.jeton.com';
                $dataFields = [
                    "orderId" => "JOY-" . $transactionId,
                    "currency" => 'TRY',
                    "amount" => $transactionPrice,
                    "returnUrl" => 'http://joybet.me',
                    "method" => "CHECKOUT",
                    "customer" => $walletCode
                ];

                $curl = curl_init();

                curl_setopt_array($curl, [
                    CURLOPT_URL => $apiUrl . "/api/v3/integration/merchants/payments/pay",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => false,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($dataFields),
                    CURLOPT_HTTPHEADER => array(
                        "X-API-KEY: " . '651723d4b40e46aca2c48a7cd7ce3050',
                        "Content-Type: application/json"
                    ),
                ]);
                $response = curl_exec($curl);
                curl_close($curl);

                $jsonData = json_decode($response);

                if (empty($jsonData->code) && !empty($jsonData->paymentId)) {
                    Transaction::where('id', $transactionId)->update([
                        'log_id' => $jsonData->paymentId
                    ]);

                    return response()->json([
                        'type' => 'success',
                        'message' => 'Ödeme Sayfası Oluşturuldu.',
                        'url' => 1,
                        'method_id' => $methodId,
                        'payment_method_url' => str_replace(['https://', 'http://'], '//', $jsonData->checkout)
                    ]);
                } else {
                    Transaction::where('id', $transactionId)->update([
                        'is_success' => 2
                    ]);

                    return response()->json([
                        'type' => 'error',
                        'message' => 'Ödeme sayfası oluşturulamadı, lütfen tekrar deneyiniz.'
                    ]);
                }
            }

            return response()->json([
                'type' => 'success',
                'message' => 'Talebiniz Alınmıştır.',
                'url' => 0,
                'method_id' => $methodId
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, daha sonra tekrar deneyiniz.'
            ]);
        }
    }

    public function testDraw()
    {
        $sendData = [
            'api_id' => 19,
            'api_key' => 'YPHtd6o4LZnQU5eANrV6xDQoJtmlTGj6',
            'user_id' => 1,
            'username' => 'erhan',
            'external_transaction_id' => '5f08479c847733826ad5se4cssa1s22',
            'first_name' => 'Erhan',
            'last_name' => 'Kolbasi',
            'amount' => 200.00,
            'account_number' => 11111111111,
            'iban' => 'TR1111111111111111111111',
            'bank_id' => 1,
            'branch_code' => 222321,
            'lang' => 'tr',
            'currency' => 'TRY'
        ];

        $post = BetAndWorksController::postData('http://joybet-payment.local/payment/draw/bank-transfer', $sendData);
        #$post = BetAndWorksController::postData('https://hit-payment.com/payment/draw/bank-transfer', $sendData);
        echo '<pre>';
        print_r($post);
    }

    public function testDeposit()
    {
        $pb = new Pushbullet('o.Boj9uVQjDNmfRWpHwJyW6JzAmGJjQiH4');

        echo '<pre>';
        print_r($pb->getPushes());
        print_r($pb->getChannelSubscriptions());
        print_r($pb->getMyChannels());
        print_r($pb->getDevices());

        die;
        $sendData = [
            'api_id' => 19,
            'api_key' => 'YPHtd6o4LZnQU5eANrV6xDQoJtmlTGj6',
            'user_id' => 1,
            'username' => 'erhan',
            'external_transaction_id' => '5f08479c8477338s26ad5sesc40',
            'first_name' => 'Erhan',
            'last_name' => 'Kolbasi',
            'lang' => 'tr',
            'currency' => 'TRY',
            'return_url_success' => 'http://success.domain',
            'return_url_fail' => 'http://fail.domain'
        ];

        $post = BetAndWorksController::postData('http://joybet-payment.local/payment/deposit/papara', $sendData);
        #$post = BetAndWorksController::postData('https://hit-payment.com/payment/deposit/bank-transfer', $sendData);
        echo '<pre>';
        print_r($post);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function createDrawBankTransferByApi(Request $request)
    {
        $transactionPrice = $request->input('amount');
        $methodId = 7;
        $apiId = $request->input('api_id');
        $apiKey = $request->input('api_key');
        $playerId = $request->input('user_id');
        $username = $request->input('username');
        $firstName = $request->input('first_name');
        $lastName = $request->input('last_name');
        $accountNumber = $request->input('account_number');
        $bankId = $request->input('bank_id');
        $iban = $request->input('iban');
        $branchCode = $request->input('branch_code');
        $externalTransactionId = $request->input('external_transaction_id');

        if (
            empty($transactionPrice) ||
            empty($methodId) ||
            empty($playerId) ||
            empty($username) ||
            empty($firstName) ||
            empty($lastName) ||
            empty($accountNumber) ||
            empty($bankId) ||
            empty($iban) ||
            empty($branchCode)
        )
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, boş alan bırakmayınız.'
            ]);

        $checkApi = Site::where('id', $apiId)->where('code', $apiKey)->first();

        if (empty($checkApi))
            return response()->json([
                'type' => 'error',
                'message' => 'Site bulunamadı, lütfen tekrar deneyiniz.'
            ]);

        $checkPlayer = Player::where('api_id', $checkApi->id)->where('external_user_id', $playerId)->first();

        if (empty($checkPlayer)) {
            $checkPlayer = Player::insertGetId([
                'api_id' => $apiId,
                'username' => $username,
                'external_user_id' => $playerId,
                'external_password' => '',
                'email' => '',
                'first_name' => $firstName,
                'last_name' => $lastName,
                'phone_number' => '',
                'status' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]);
        }

        # Generate Hash
        $randomNumber = rand(1000,999999);
        $generateHash = hash("sha512", http_build_query([
            $apiId,
            $apiKey,
            $playerId,
            $username,
            !empty($externalTransactionId) ? $externalTransactionId : $checkPlayer->id . $randomNumber
        ]));

        $privateCode = time();
        $transactionData = [
            'api_id' => $checkApi->id,
            'transaction_type' => $methodId,
            'bank_account_id' => 0,
            'external_transaction_id' => $externalTransactionId,
            'transaction_send_data' => json_encode($request->all()),
            'player_id' => $checkPlayer->id,
            'amount' => $transactionPrice,
            'is_success' => 0,
            'user_id' => 0,
            'log_id' => $privateCode,
            'customer_note' => '',
            'hash' => $generateHash,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ];

        $paymentMethod = PaymentMethod::where('status', 1)->where('id', $methodId)->first();

        if (empty($paymentMethod))
            return response()->json([
                'type' => 'error',
                'message' => 'Seçilen ödeme yöntemi aktif değildir.'
            ]);

        # check payment method max amount
        if ($transactionPrice > $paymentMethod->max_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Maximum Limit : ' . $paymentMethod->max_amount
            ]);

        # check payment method min amount
        if ($transactionPrice < $paymentMethod->min_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Minimum Limit : ' . $paymentMethod->min_amount
            ]);

        $checkTransaction = Transaction::where('api_id', $checkApi->id)
            ->where('player_id', $checkPlayer->id)
            ->where('is_success', 0)
            ->where('transaction_type', $paymentMethod->id)
            ->count();

        if ($checkTransaction > 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Aktif bekleyen talebiniz mevcut, lütfen aktif talebinizin sonuçlanmasını bekleyin.'
            ]);

        $transactionId = Transaction::insertGetId($transactionData);

        if ($transactionId) {
            return response()->json([
                'type' => 'success',
                'message' => 'Talebiniz Alınmıştır.',
                'url' => 0,
                'method_id' => $methodId,
                'transaction_id' => $transactionId
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, daha sonra tekrar deneyiniz.'
            ]);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function createDrawPaparaByApi(Request $request)
    {
        $transactionPrice = $request->input('amount');
        $methodId = 8;
        $apiId = $request->input('api_id');
        $apiKey = $request->input('api_key');
        $playerId = $request->input('user_id');
        $username = $request->input('username');
        $firstName = $request->input('first_name');
        $lastName = $request->input('last_name');
        $accountNumber = $request->input('account_number');
        $externalTransactionId = $request->input('external_transaction_id');

        if (
            empty($transactionPrice) ||
            empty($methodId) ||
            empty($playerId) ||
            empty($username) ||
            empty($firstName) ||
            empty($lastName) ||
            empty($accountNumber)
        )
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, boş alan bırakmayınız.'
            ]);

        $checkApi = Site::where('id', $apiId)->where('code', $apiKey)->first();

        if (empty($checkApi))
            return response()->json([
                'type' => 'error',
                'message' => 'Site bulunamadı, lütfen tekrar deneyiniz.'
            ]);

        $checkPlayer = Player::where('api_id', $checkApi->id)->where('external_user_id', $playerId)->first();

        if (empty($checkPlayer))
            return response()->json([
                'type' => 'error',
                'message' => 'Kullanıcı bulunamadı, lütfen tekrar deneyiniz.'
            ]);

        $privateCode = time();
        $transactionData = [
            'api_id' => $checkApi->id,
            'transaction_type' => $methodId,
            'bank_account_id' => 0,
            'external_transaction_id' => $externalTransactionId,
            'transaction_send_data' => json_encode($request->all()),
            'player_id' => $checkPlayer->id,
            'amount' => $transactionPrice,
            'is_success' => 0,
            'user_id' => 0,
            'log_id' => $privateCode,
            'customer_note' => '',
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ];

        $paymentMethod = PaymentMethod::where('status', 1)->where('id', $methodId)->first();

        if (empty($paymentMethod))
            return response()->json([
                'type' => 'error',
                'message' => 'Seçilen ödeme yöntemi aktif değildir.'
            ]);

        # check payment method max amount
        if ($transactionPrice > $paymentMethod->max_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Maximum Limit : ' . $paymentMethod->max_amount
            ]);

        # check payment method min amount
        if ($transactionPrice < $paymentMethod->min_amount)
            return response()->json([
                'type' => 'error',
                'message' => 'Minimum Limit : ' . $paymentMethod->min_amount
            ]);

        $checkTransaction = Transaction::where('api_id', $checkApi->id)
            ->where('player_id', $checkPlayer->id)
            ->where('is_success', 0)
            ->where('transaction_type', $paymentMethod->id)
            ->count();

        if ($checkTransaction > 0)
            return response()->json([
                'type' => 'error',
                'message' => 'Aktif bekleyen talebiniz mevcut, lütfen aktif talebinizin sonuçlanmasını bekleyin.'
            ]);

        $transactionId = Transaction::insertGetId($transactionData);

        if ($transactionId) {
            return response()->json([
                'type' => 'success',
                'message' => 'Talebiniz Alınmıştır.',
                'url' => 0,
                'method_id' => $methodId,
                'transaction_id' => $transactionId
            ]);
        } else {
            return response()->json([
                'type' => 'error',
                'message' => 'Lütfen, daha sonra tekrar deneyiniz.'
            ]);
        }
    }

    /**
     * @param Request $request
     */
    public function createPlayer(Request $request)
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");

        $username = $request->input('username');
        $password = $request->input('password'); // for joybet platform
        $userId = $request->input('user_id');
        $apiId = $request->input('api_id');
        $firstName = $request->input('first_name');
        $lastName = $request->input('last_name');
        $email = $request->input('email');
        $phoneNumber = $request->input('phone_number');

        $checkSite = Site::where('code', $apiId)->where('status', 1)->first();

        if (!empty($checkSite)) {
            Player::insert([
                'api_id' => $checkSite->id,
                'username' => $username,
                'external_user_id' => $userId,
                'external_password' => $password,
                'email' => $email,
                'first_name' => $firstName,
                'last_name' => $lastName,
                'phone_number' => $phoneNumber,
                'status' => 1
            ]);
        }
    }
}
