<?php
/**
 * Created by PhpStorm.
 * Filename: ApiController.php
 * Description:
 * User: orhanbhr
 * Date: 29.10.2020
 * Time: 10:51
 */

namespace App\Http\Controllers;


use App\Bank;
use App\Site;
use App\WhiteListIp;
use Illuminate\Http\Request;

class ApiController
{
    public $supportLang = [
        'tr',
        'en'
    ];

    public $supportCurrency = [
        'TRY',
        'USD',
        'EUR'
    ];

    public function getBankList(Request $request)
    {
        $apiId = $request->input('api_id');
        $apiKey = $request->input('api_key');
        $lang = $request->input('lang');
        $currency = $request->input('currency');

        # Check IP Address
        $checkIpAddress = WhiteListIp::checkIpAddress();
        if (!$checkIpAddress)
            return response()->json([
                'code' => 1012,
                'type' => 'error',
                'message' => trans('pay.error_1012'),
                'ip_address' => WhiteListIp::getIpAddress()
            ]);

        if (
            empty($apiId) ||
            empty($apiKey) ||
            empty($lang) ||
            empty($currency)
        )
            return response()->json([
                'code' => 1001,
                'type' => 'error',
                'message' => trans('pay.error_1001')
            ]);

        # Lang Dedection
        if (in_array($lang, $this->supportLang)) {
            app()->setLocale($lang);
        } else {
            app()->setLocale('en');

            return response()->json([
                'code' => 1010,
                'type' => 'error',
                'message' => trans('pay.error_1010')
            ]);
        }

        # Currency Dedection
        if (!in_array($currency, $this->supportCurrency)) {
            app()->setLocale('en');

            return response()->json([
                'code' => 1011,
                'type' => 'error',
                'message' => trans('pay.error_1011')
            ]);
        }

        $checkApi = Site::where('id', $apiId)->where('code', $apiKey)->first();

        if (empty($checkApi))
            return response()->json([
                'code' => 1002,
                'type' => 'error',
                'message' => trans('pay.error_1002')
            ]);

        if ($checkApi->status != 1)
            return response()->json([
                'code' => 1003,
                'type' => 'error',
                'message' => trans('pay.error_1003')
            ]);

        $getBankList = Bank::where('status', 1)->get();
        $dataBankList = [];

        if (empty($getBankList))
            return response()->json([
                'code' => 1013,
                'type' => 'error',
                'message' => trans('pay.error_1013')
            ]);

        if (!empty($getBankList))
            foreach ($getBankList as $bank) {
                $dataBankList[] = [
                    'id' => $bank->id,
                    'name' => $bank->name,
                    'mobile_bank_status' => $bank->mobile_bank,
                    'param_status' => $bank->param,
                    'updated_at' => $bank->updated_at->format('Y-m-d H:i:s')
                ];
            }

        return response()->json([
            'code' =>  200,
            'type' => 'success',
            'message' => trans('pay.success_200'),
            'banks' => $dataBankList
        ]);
    }
}
