<?php echo $__env->make('panel.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php
    $totalData = [
        'deposit' => 0,
        'deposit_piece' => 0,
        'withdraw' => 0,
        'withdraw_piece' => 0
    ];
?>
<?php if(count($transactions) > 0): ?>
    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $totalData['deposit'] += $transaction['counts']['deposit']['amount'];
            $totalData['deposit_piece'] += $transaction['counts']['deposit']['piece'];
            $totalData['withdraw'] += $transaction['counts']['withdraw']['amount'];
            $totalData['withdraw_piece'] += $transaction['counts']['withdraw']['piece'];
        ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce p-lg-5">
        <div class="row" style="margin: -20px -15px 20px 0">
            <div class="col-lg-10">
            </div>

            <div class="col-lg-2 text-right">
                <a href="<?php echo e(url('/admin/dashboard?cache=clear')); ?>" class="btn btn-warning btn-lg btn-block">Temizle</a>
            </div>
        </div>

        <div class="row mb-5">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header white">
                        <strong> GÜNLÜK İSTATİSTİK </strong>
                    </div>
                    <div class="card-body p-0">
                        <div class="row no-gutters">
                            <div class="col-md-2">
                                <div class="p-5 light">
                                    <h5 class="font-weight-normal s-14">Yeni Oyuncu</h5>
                                    <span class="s-24 font-weight-lighter text-primary"><?php echo e($activePlayer); ?></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="p-5">
                                    <h5 class="font-weight-normal s-14">Aktif Oyuncular</h5>
                                    <span class="s-24 font-weight-lighter light-green-text"><?php echo e($activeTransactionPlayers); ?></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="p-5 light">
                                    <h5 class="font-weight-normal s-14">Toplam Yatırım</h5>
                                    <span class="s-24 font-weight-lighter text-primary"><?php echo e(number_format($totalData['deposit'], 2)); ?></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="p-5">
                                    <h5 class="font-weight-normal s-14">Toplam Çekim</h5>
                                    <span class="s-24 font-weight-lighter amber-text"><?php echo e(number_format($totalData['withdraw'], 2)); ?></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="p-5 light">
                                    <h5 class="font-weight-normal s-14">Kar/Zarar</h5>
                                    <span class="s-24 font-weight-lighter text-indigo"><?php echo e(number_format($totalData['deposit'] - $totalData['withdraw'], 2)); ?></span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="p-5">
                                    <h5 class="font-weight-normal s-14">Toplam İşlem Sayısı</h5>
                                    <span class="s-24 font-weight-lighter pink-text"><?php echo e($totalData['deposit_piece'] + $totalData['withdraw_piece']); ?></span>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>



        </div>
        <div class="card-group my-4">
            <table class="table table-condensed table-bordered table-striped">
                <thead>
                <tr>
                    <th>Ödeme Yöntemi</th>
                    <th>Yatırım</th>
                    <th>&nbsp;</th>
                    <th>Çekim</th>
                    <th>&nbsp;</th>
                    <th>Kar/Zarar</th>
                </tr>
                </thead>
                <tbody>
                    <?php if(count($transactions) > 0): ?>
                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($transaction['paymentMethod']['name']); ?></td>
                                <td><?php echo e(number_format($transaction['counts']['deposit']['amount'], 2)); ?></td>
                                <td><?php echo e($transaction['counts']['deposit']['piece']); ?></td>
                                <td><?php echo e(number_format($transaction['counts']['withdraw']['amount'], 2)); ?></td>
                                <td><?php echo e($transaction['counts']['withdraw']['piece']); ?></td>
                                <td><?php echo e(number_format($transaction['counts']['deposit']['amount'] - $transaction['counts']['withdraw']['amount'], 2)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                <tr>
                    <td>TOPLAM</td>
                    <td><?php echo e(number_format($totalData['deposit'], 2)); ?></td>
                    <td><?php echo e($totalData['deposit_piece']); ?></td>
                    <td><?php echo e(number_format($totalData['withdraw'], 2)); ?></td>
                    <td><?php echo e($totalData['withdraw_piece']); ?></td>
                    <td><?php echo e(number_format($totalData['deposit'] - $totalData['withdraw'], 2)); ?></td>
                </tr>
                </tfoot>
            </table>
        </div>

        <div class="card-group my-4">
            <table class="table table-condensed table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>Carbon</th>
                        <td><?php echo e(\Illuminate\Support\Carbon::now()); ?></td>
                    </tr>
                    <tr>
                        <th>Date</th>
                        <td><?php echo e(date('Y-m-d H:i:s')); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="card-group my-12">
            <div class="alert alert-warning w-100" role="alert">
                Bu sayfada gösterilen verilen gerçek zamanlı değildir. 5 dakikalık aralıklarla güncellenmektedir.
                <b>En son güncellenme tarihi : <?php echo e($cacheDate->format('Y-m-d H:i:s')); ?></b>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('panel.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/bpaparac/public_html/resources/views/panel/dashboard.blade.php ENDPATH**/ ?>