# Request & Response

---

- [Info](#section-1)
- [Example Request](#section-2)
- [Example Response](#section-3)

<a name="section-1"></a>
## Info

You can find the sample requests and response values sent by us below and you can easily provide seamless wallet integration. If a request is not completed within 30 minutes, a cancellation request is sent to you for this process. If you want to cancel earlier, you can cancel by specifying a minimum of 10 minutes on your side. If the cancellation request did not come within 30 minutes or more, this process is in the process of being controlled. <b>Please check the security section for the hash calculation on the response side.</b>

<a name="section-2"></a>
## Example Request
```javascript
{
    "apiId": 1,
    "apiKey": "x3dfjkasdo12332",
    "paymentId": 123,
    "userId": 100,
    "username": "pay_test",
    "type": "deposit", // deposit or withdraw
    "amount": 100.5,
    "externalTransactionId": 123456789,
    "status": true, // If status=true, the transaction is approved.
    "message": "success",
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

```javascript
{
    "apiId": 1,
    "apiKey": "x3dfjkasdo12332",
    "paymentId": 123,
    "userId": 100,
    "username": "pay_test",
    "type": "deposit", // deposit or withdraw
    "amount": 100.5,
    "externalTransactionId": 123456789,
    "status": false, // If status=false, the transaction was rejected.
    "message": "no deposit",
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

<a name="section-3"></a>
## Example Response


<h4>This is the response value that should be for all successful cases such as Deposit Approved, Deposit Rejected, Withdraw Approved, Withdraw Rejected.</h4>
```javascript
{
    "status": 200,
    "message": "success",
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

<h4>It is the response value that should be when any successful request is sent to you 2nd or more times. (Important Note: If this response is returned, no accounting process should be done.)</h4>
```javascript
{
    "status": 201,
    "message": "transaction already",
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

<h4>This is the response value that should be returned in all error cases. For example, the transaction was not found.</h4>
```javascript
{
    "status": 404,
    "message": "transaction not found",
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

<h4>IP whitelist, empty request, server errors etc. It is the response value that should be in such cases.</h4>
```javascript
{
    "status": 500,
    "message": "internal server error"
}
```

> {info} Please make sure your seamless address is a JSON page. An example for PHP is header('Content-type: application/json'); You can use.
