<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    protected $table = 'users';

    /**
     * @param $roleId
     * @return string
     */
    public static function getRole($roleId)
    {
        switch ($roleId) {
            case 1:
                return 'Supervisor';
                break;

            case 2:
                return 'Agent';
                break;

            case 3:
                return 'Website Admin';
                break;

            case 4:
                return 'Website Operator';
                break;

            default:
                return 'Unknown';
                break;
        }
    }

    public function sites()
    {
        return $this->belongsTo(Site::class, 'api_id');
    }

    public static function googleAuthenticatorLoginDisable($userId)
    {
        return self::where('id', $userId)->update([
            'ga_login' => 0,
            'updated_at' => Carbon::now()
        ]);
    }

    public static function googleAuthenticatorLoginEnable($userId)
    {
        return self::where('id', $userId)->update([
            'ga_login' => 1,
            'updated_at' => Carbon::now()
        ]);
    }
}
