<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Jenssegers\Agent\Agent;

class RequestLog extends Model
{
    protected $table = 'request_logs';

    /**
     * @return BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * @param $transactionId
     * @param $userId
     * @param $typeId
     * @param $requestContent
     * @param $responseContent
     * @param $elapsedTime
     * @return mixed
     */
    public static function addLog(
        $transactionId,
        $userId,
        $typeId,
        $requestContent,
        $responseContent,
        $elapsedTime
    )
    {
        $agent = new Agent();

        return self::query()
            ->insert([
                'transaction_id' => $transactionId,
                'user_id' => $userId,
                'type_id' => $typeId,
                'request_content' => json_encode($requestContent),
                'response_content' => json_encode($responseContent),
                'elapsed_time' => !empty($elapsedTime) ? $elapsedTime : 0,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]);
    }
}
