<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use Carbon\Carbon;
use Illuminate\Http\Request;

class SeamlessController extends Controller
{
    /**
     * @param Request $request
     */
    public function methodJetonPayIn(Request $request)
    {
        $data = json_decode($request->getContent());

        // Onaylandı
        if ($data->status == 'SUCCESS') {
            $checkTransaction = Transaction::where('log_id', $data->paymentId)->first();

            if (count($checkTransaction) && $checkTransaction->is_success == 0) {
                $depositAmount = JoyBetController::depositAdminBalance($checkTransaction->player->external_user_id, $data->amount);

                if ($depositAmount) {
                    Transaction::where('log_id', $data->paymentId)->update([
                        'is_success' => 1
                    ]);
                }
            }
        }

        // Red Edildi
        if ($data->status == 'FAILED') {
            Transaction::where('log_id', $data->paymentId)->update([
                'is_success' => 2,
                'pay_note' => $data->message
            ]);
        }
    }

    /**
     * @param Request $request
     */
    public function methodJetonPayOut(Request $request)
    {
        $data = json_decode($request->getContent());

        // Onaylandı
        if ($data->status == 'SUCCESS') {
            $transactionId = str_replace('JOY-', '', $data->orderId);
            Transaction::where('id', $transactionId)->update([
                'is_success' => 1
            ]);
        }

        // Red Edildi
        if ($data->status == 'FAILED') {
            $transactionId = str_replace('BWS-', '', $data->orderId);
            $checkTransaction = Transaction::where('id', $transactionId)->first();

            if (count($checkTransaction) && $checkTransaction->is_success == 3) {
                $depositAmount = JoyBetController::depositAdminBalance($checkTransaction->player->external_user_id, $data->amount);

                if ($depositAmount) {
                    Transaction::where('id', $checkTransaction->id)->update([
                        'is_success' => 2,
                        'pay_note' => $data->message
                    ]);
                }
            }
        }
    }

    /**
     * @param $url
     * @param array $parameters
     * @return array
     */
    public static function postData($url, $parameters = [])
    {
        $fields_string = http_build_query($parameters);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        $response = curl_exec($ch);

        $info = curl_getinfo($ch);

        curl_close($ch);

        #echo '<pre>'; echo $url; echo '<br />'; print_r($parameters);print_r($response); die;

        $json = json_decode($response);

        return [
            'response' => $json,
            'time' => $info['total_time'],
            'url' => $info['url']
        ];
    }
}
