<?php

namespace App\Http\Controllers;

use App\Bank;
use App\BankAccount;
use App\PaymentMethod;
use App\Player;
use App\Site;
use App\Transaction;
use App\User;
use Illuminate\Http\Request;

class PaParaController extends Controller
{
    public static function connect($path, $username, $password, $seen = 0, $max = 10)
    {
        # Open Connection
        $inbox = @imap_open($path, $username, $password);

        $errors = imap_errors();
        if (!empty($errors))
            return [
                'status' => false,
                'data' => [],
                'errors' => $errors
            ];

        # Const Attributes
        $output = [
            'status' => true,
            'data' => [],
            'errors' => []
        ];
        $i = 0;

        # Search Unseen Mails
        $emails = imap_search($inbox,'UNSEEN', SE_FREE, "UTF-8");

        if (empty($emails))
            return $output;

        # Order By DESC
        rsort($emails);

        # List Mails
        foreach ($emails as $mail) {
            $headerInfo = imap_headerinfo($inbox, $mail);

            if (!empty($headerInfo->from[0]->personal)) {
                if ($headerInfo->from[0]->personal == 'Papara') {
                    $emailStructure = imap_fetchstructure($inbox, $mail);

                    if (!isset($emailStructure->parts)) {
                        if ($seen)
                            $overview = imap_body($inbox, $mail);
                        else
                            $overview = imap_body($inbox, $mail, FT_PEEK);

                        $message = quoted_printable_decode($overview);
                        $mailContent = str_replace("\n", "", $message);
                        $output['data'][] = self::regexMail($mailContent);
                    } else {
                        // unknown
                    }
                }
            }

            $i++;

            if ($i > $max)
                break;
        }

        # Close Connection
        imap_expunge($inbox);
        imap_close($inbox);

        # Output Connection
        return $output;
    }

    /**
     * @param $mailContent
     * @return array
     */
    private static function regexMail($mailContent)
    {
        if (empty($mailContent))
            return [
                'status' => false
            ];

        preg_match_all("/<td.*>(.*)<\\/td>/Ui", $mailContent, $mailContentRegex);

        if (!empty($mailContentRegex[1][3])) {
            if (strpos($mailContentRegex[1][3], 'gönderdi') !== false) {
                $replaceContent = explode('size', str_replace(['gönderdi',' sana '], ['', ' size '], $mailContentRegex[1][3]));
                $replaceName = trim($replaceContent[0]);
                $replaceMoneyContent = explode(' ', trim($replaceContent[1]));
                $replaceMoney = $replaceMoneyContent[0];
                $replaceCurrency = $replaceMoneyContent[1];

                if (!empty($replaceMoney)) {
                    $replaceMoney = str_replace('.', '', $replaceMoney);
                    $replaceMoney = str_replace(',', '.', $replaceMoney);
                } else {
                    $replaceMoney = 0.00;
                }

                return [
                    'status' => true,
                    'sender' => $replaceName,
                    'money' => $replaceMoney,
                    'currency' => $replaceCurrency
                ];
            }
        }

        return [
            'status' => false
        ];
    }
}
