<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="/panel/img/basic/favicon.ico" type="image/x-icon">
    <title>Payment Panel</title>
    <!-- CSS -->
    <link rel="stylesheet" href="/panel/css/app.css">
    <style>
        .loader {
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: #F5F8FA;
            z-index: 9998;
            text-align: center;
        }

        .plane-container {
            position: absolute;
            top: 50%;
            left: 50%;
        }
    </style>
</head>
<body class="light">
<!-- Pre loader -->
<div id="loader" class="loader">
    <div class="plane-container">
        <div class="preloader-wrapper small active">
            <div class="spinner-layer spinner-blue">
                <div class="circle-clipper left">
                    <div class="circle"></div>
                </div><div class="gap-patch">
                    <div class="circle"></div>
                </div><div class="circle-clipper right">
                    <div class="circle"></div>
                </div>
            </div>

            <div class="spinner-layer spinner-red">
                <div class="circle-clipper left">
                    <div class="circle"></div>
                </div><div class="gap-patch">
                    <div class="circle"></div>
                </div><div class="circle-clipper right">
                    <div class="circle"></div>
                </div>
            </div>

            <div class="spinner-layer spinner-yellow">
                <div class="circle-clipper left">
                    <div class="circle"></div>
                </div><div class="gap-patch">
                    <div class="circle"></div>
                </div><div class="circle-clipper right">
                    <div class="circle"></div>
                </div>
            </div>

            <div class="spinner-layer spinner-green">
                <div class="circle-clipper left">
                    <div class="circle"></div>
                </div><div class="gap-patch">
                    <div class="circle"></div>
                </div><div class="circle-clipper right">
                    <div class="circle"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="app">
    <aside class="main-sidebar fixed offcanvas b-r" data-toggle='offcanvas'>
        <section class="sidebar">
            <ul class="sidebar-menu mt-4">
                <li>
                    <a href="/admin/dashboard">
                        <i class="icon icon-sailing-boat-water s-24"></i>
                        <span>Ana Sayfa</span>
                    </a>
                </li>
                <?php if($user->role_id == 1): ?>
                <li>
                    <a href="/admin/sites">
                        <i class="icon icon icon-package s-24"></i>
                        <span>Siteler</span>
                    </a>
                </li>
                <li>
                    <a href="/admin/operators">
                        <i class="icon icon-account_box s-24"></i>
                        <span>Operatörler</span>
                    </a>
                </li>
                <li>
                    <a href="/admin/whitelist-ip">
                        <i class="icon icon-link s-24"></i>
                        <span>Tanımlanan IP Adresleri</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if($user->role_id == 3 || $user->role_id == 4): ?>
                    <li>
                        <a href="/admin/get-bank-accounts">
                            <i class="icon icon-bank s-24"></i>
                            <span>Hesap Bilgisi Al</span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if($user->role_id != 2 && $user->access_manuel_transaction == 1): ?>
                    <li>
                        <a href="/admin/create-manual-transaction">
                            <i class="icon icon-plus s-24"></i>
                            <span>Talep Oluştur</span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if($user->role_id != 4): ?>
                <li>
                    <a href="/admin/transactions">
                        <i class="icon icon-package s-24"></i>
                        <span>Yatırım/Çekim Talepleri</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if($user->role_id != 3 && $user->role_id != 4): ?>
                <li>
                    <a href="/admin/players">
                        <i class="icon icon-goals-1 s-24"></i>
                        <span>Oyuncular</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php if($user->role_id != 4): ?>
                <li>
                    <a href="/admin/reports">
                        <i class="icon icon-bar-chart2  s-24"></i>
                        <span>Genel Rapor</span>
                    </a>
                </li>
                <?php endif; ?>
                <li class="treeview">
                    <a href="#" id="account-menu">
                        <i class="icon icon-bar-chart  s-24"></i>
                        <span>İstatistikler</span>
                        <i class=" icon-angle-left  pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li>
                            <a href="/admin/statistics/operators">
                                <i class="icon icon-brightness_auto light-blue-text s-14"></i>
                                <span>Operatörler</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php if($user->access_push_bullet == 1): ?>
                    <li>
                        <a href="/admin/push-bullet">
                            <i class="icon icon-message s-24"></i>
                            <span>PushBullet</span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if($user->role_id == 1 || $user->role_id == 2): ?>
                <li class="treeview">
                    <a href="#" id="account-menu">
                        <i class="icon icon-dialpad  s-24"></i>
                        <span>Hesap Yönetimi</span>
                        <i class=" icon-angle-left  pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <?php if($user->role_id == 1): ?>
                        <li>
                            <a href="/admin/account-management/banks">
                                <i class="icon icon-brightness_auto light-blue-text s-14"></i>
                                <span>Bankalar</span>
                            </a>
                        </li>
                        <li>
                            <a href="/admin/account-management/deposit-range">
                                <i class="icon icon-random light-blue-text s-14"></i>
                                <span>Yatırım Aralığı</span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <li>
                            <a href="/admin/account-management/accounts">
                                <i class="icon icon-camera2 light-blue-text s-14"></i>
                                <span>Hesaplar</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
                <?php if($user->role_id == 1): ?>
                <li class="treeview">
                    <a href="#" id="account-menu">
                        <i class="icon icon-star4  s-24"></i>
                        <span>Saklanax</span>
                        <i class=" icon-angle-left  pull-right"></i>
                    </a>
                    <ul class="treeview-menu">
                        <li>
                            <a href="/admin/account-management/banks">
                                <i class="icon icon-brightness_auto light-blue-text s-14"></i>
                                <span>Bankalar</span>
                            </a>
                        </li>
                        <li>
                            <a href="/admin/account-management/banks">
                                <i class="icon icon-brightness_auto light-blue-text s-14"></i>
                                <span>Ayarlar</span>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>
                <?php if($user->role_id == 1): ?>
                <li>
                    <a href="/admin/payment-methods">
                        <i class="icon icon-credit-card s-24"></i>
                        <span>Ödeme Yöntemleri</span>
                    </a>
                </li>
                <?php endif; ?>
                <li>
                    <a href="/admin/logs">
                        <i class="icon icon-history s-24"></i>
                        <span>İşlem Geçmişi</span>
                    </a>
                </li>
                <?php if($user->role_id == 1): ?>
                <li>
                    <a href="/admin/api_logs">
                        <i class="icon icon-refresh s-24"></i>
                        <span>API/Seamless Logs</span>
                    </a>
                </li>
                <li>
                    <a href="/admin/cron_jobs">
                        <i class="icon icon-clock-o s-24"></i>
                        <span>Cron Jobs</span>
                    </a>
                </li>
                <?php endif; ?>
                <li>
                    <a href="/admin/profile">
                        <i class="icon icon-profile s-24"></i>
                        <span>Profili Düzenle</span>
                    </a>
                </li>
                <li>
                    <a href="/admin/g2a">
                        <i class="icon icon-google s-24"></i>
                        <span>Google Authenticator</span>
                    </a>
                </li>
                <?php if($user->role_id == 1): ?>
                    <li>
                        <a href="/admin/settings">
                            <i class="icon icon-cog s-24"></i>
                            <span>Genel Ayarlar</span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
            <div class="relative pt-5">
                <div class="user-panel p-4 mb-2">
                    <div>
                        <div class="info">
                            <h5 class="mt-2 mb-1"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h5>
                            <span class="s-12"><?php echo e(\App\User::getRole($user->role_id)); ?></span>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="collapse multi-collapse" id="userSettingsCollapse">
                        <div class="list-group mt-3 shadow">
                            <a href="index.html" class="list-group-item list-group-item-action ">
                                <i class="mr-2 icon-umbrella text-blue"></i>Profile
                            </a>
                            <a href="#" class="list-group-item list-group-item-action"><i
                                        class="mr-2 icon-cogs text-yellow"></i>Settings</a>
                            <a href="#" class="list-group-item list-group-item-action"><i
                                        class="mr-2 icon-security text-purple"></i>Change Password</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </aside>
    <!--Sidebar End-->
    <div class="sticky">
        <div class="navbar navbar-expand d-flex justify-content-between bd-navbar white b-b">
            <div class="relative">
                <div class="d-flex">
                    <div>
                        <a href="#" data-toggle="push-menu" class="paper-nav-toggle pp-nav-toggle">
                            <i></i>
                        </a>
                    </div>
                    <ul class="nav responsive-tab nav-material nav-material-white mt-1 ml-3" id="v-pills-tab">
                        <li>
                            <a class="nav-link" id="v-pills-1-tab" href="/admin/transactions?type_id=1&status=0">
                                <i class="mr-3 icon-arrow-circle-o-up"></i>Yatırım Talepleri (<span class="depositCount">0</span>)</a>
                        </li>
                        <li>
                            <a class="nav-link" id="v-pills-2-tab" href="/admin/transactions?type_id=2&status=0"><i
                                        class="icon icon-arrow-circle-o-down"></i>Çekim Talepleri (<span class="withdrawCount">0</span>)</a>
                        </li>
                        <?php if($user->role_id == 1 || $user->role_id == 3): ?>
                        <li>
                            <a class="nav-link" id="v-pills-3-tab" href="/admin/reports"><i
                                        class="icon icon-calendar"></i>Genel Rapor</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <!--Top Menu Start -->
            <div class="navbar-custom-menu d-flex align-items-center">
                <ul class="nav navbar-nav">
                    <!-- Messages-->
                    <li class="dropdown custom-dropdown messages-menu">
                        <a href="/admin/transactions?type_id=1&status=0" class="nav-link pl-lg-3 pr-lg-3 b-l">
                            <i class="icon-arrow-circle-o-up"></i>
                            <span class="badge badge-success badge-mini rounded-circle depositCount">0</span>
                        </a>
                    </li>
                    <!-- Notifications -->
                    <li class="dropdown custom-dropdown notifications-menu">
                        <a href="/admin/transactions?type_id=2&status=0" class="nav-link  b-r b-l pl-lg-3 pr-lg-3">
                            <i class="icon-arrow-circle-o-down"></i>
                            <span class="badge badge-danger badge-mini rounded-circle withdrawCount">0</span>
                        </a>
                    </li>
                </ul>
                <!-- Button -->
                <div>
                    <a href="<?php echo e(url('/admin/logout')); ?>" class="btn btn-primary btn-sm ml-3 d-none d-sm-block">Çıkış Yap</a>
                </div>
            </div>

        </div>
    </div>
<?php /**PATH /home/bpaparac/public_html/resources/views/panel/includes/header.blade.php ENDPATH**/ ?>