<?php if(count($transactions) > 0): ?>
    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr style="cursor: pointer" process-id="<?php echo e($transaction->id); ?>" class="detailTransaction">
            <td><?php echo e($transaction->id); ?></td>
            <td><?php echo e($transaction->sites->name); ?></td>
            <td id="type<?php echo e($transaction->payment_method->type); ?>"><?php echo e(\App\PaymentMethod::getType($transaction->payment_method->type)); ?></td>
            <td>
              <a href="/admin/players/show/<?php echo e($transaction->player_id); ?>">
                <?php if($transaction->sites->platform === 3 || $transaction->sites->platform === 2): ?>
                  <?php echo e($transaction->player->external_user_id); ?>

                <?php else: ?>
                  <?php echo e($transaction->player->username); ?>

                <?php endif; ?>
                (<?php echo e($transaction->player->first_name . ' '. $transaction->player->last_name); ?>)
              </a>
            </td>
            <td><?php echo e($transaction->payment_method->name); ?></td>
            <td><?php echo e($transaction->amount); ?></td>
            <td>
                <?php if($transaction->is_success == 1): ?>
                    <span class="badge text-white bg-green">Onaylandı</span>
                <?php elseif($transaction->is_success == 2): ?>
                    <span class="badge text-white bg-danger">Rededildi</span>
                <?php elseif($transaction->is_success == 3): ?>
                    <span class="badge text-white bg-info">Kontrol Ediliyor</span>
                <?php else: ?>
                    <span class="badge text-white bg-warning">Yeni Talep</span>
                <?php endif; ?>
            </td>
            <td><?php echo e($transaction->created_at); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <tr>
        <td colspan="8">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
<?php endif; ?>

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '<?php echo e($transactions->total()); ?>',
        perPage: '<?php echo e($transactions->perPage()); ?>',
        currentPage: '<?php echo e($transactions->currentPage()); ?>',
    };
</script>
<?php /**PATH /home/bpaparac/public_html/resources/views/panel/transaction_list.blade.php ENDPATH**/ ?>