<!DOCTYPE html>
<html lang="tr">
<head>
    <title>{{ $transaction->sites->name }} - Para Yatırma - {{ env('PAY_WEBSITE_NAME') }}</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta http-equiv="Content-Language" content="tr"/>
    @if(env('PAY_WEBSITE_ICON'))
    <link rel="icon" type="image/png" href="{{ env('PAY_WEBSITE_ICON') }}"/>
    @endif
    <link href="/v2/css/material-design-iconic-font.min.css" rel="stylesheet" media="all">
    <link href="/v2/css/font-awesome.min.css" rel="stylesheet" media="all">
    <link href="//fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link rel="stylesheet" href="//stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <link href="/v2/css/daterangepicker.css" rel="stylesheet" media="all">
    <link href="/v2/css/main.css" rel="stylesheet" media="all">

    @if(!empty($transaction->sites->return_url))
    <meta name="return_url" content="{{ $transaction->sites->return_url }}">
    @endif

    @if(!empty($transaction->sites->return_url_fail))
    <meta name="return_url_fail" content="{{ $transaction->sites->return_url_fail }}">
    @endif

    @include('v2.custom_css')
</head>
<body>
<div class="loader loader--style2" title="Lütfen Bekleyiniz...">
    <svg width="100" height="100" viewBox="0 0 57 57" xmlns="http://www.w3.org/2000/svg" stroke="#17a2b8">
        <g fill="none" fill-rule="evenodd">
            <g transform="translate(1 1)" stroke-width="2">
                <circle cx="5" cy="50" r="5">
                    <animate attributeName="cy"
                             begin="0s" dur="2.2s"
                             values="50;5;50;50"
                             calcMode="linear"
                             repeatCount="indefinite" />
                    <animate attributeName="cx"
                             begin="0s" dur="2.2s"
                             values="5;27;49;5"
                             calcMode="linear"
                             repeatCount="indefinite" />
                </circle>
                <circle cx="27" cy="5" r="5">
                    <animate attributeName="cy"
                             begin="0s" dur="2.2s"
                             from="5" to="5"
                             values="5;50;50;5"
                             calcMode="linear"
                             repeatCount="indefinite" />
                    <animate attributeName="cx"
                             begin="0s" dur="2.2s"
                             from="27" to="27"
                             values="27;49;5;27"
                             calcMode="linear"
                             repeatCount="indefinite" />
                </circle>
                <circle cx="49" cy="50" r="5">
                    <animate attributeName="cy"
                             begin="0s" dur="2.2s"
                             values="50;50;5;50"
                             calcMode="linear"
                             repeatCount="indefinite" />
                    <animate attributeName="cx"
                             from="49" to="49"
                             begin="0s" dur="2.2s"
                             values="49;5;27;49"
                             calcMode="linear"
                             repeatCount="indefinite" />
                </circle>
            </g>
        </g>
    </svg>
</div>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-4 offset-md-4 myPage">
            <div class="myWrapper">
                <div class="row" style="margin-bottom: 25px; opacity: .9;">
                    <div class="col-md-8">
                        <h6>Papara ile para yatırma</h6>
                    </div>
                    <div class="col-md-4" style="text-align: right;">
                        <h6><a style="text-decoration: none;" href="/pay?hash={{ $payHash }}">Geri</a></h6>
                    </div>
                </div>

                <form id="PaparaDeposit" action="javascript:;">
                    <div class="form-row">
                        <input type="hidden" name="site-username" value="{{ $transaction->player->username }}"/>
                        <!--<input type="hidden" name="site-fullname" value="{{ $transaction->player->first_name . ' ' . $transaction->player->last_name }}"/>-->

                        <div class="alert alert-warning" role="alert">
                          <b>DİKKAT !</b>
                          LÜTFEN YATIRIM YAPARKEN AÇIKLAMA ALANINI BOŞ BIRAKINIZ !!
                        </div>

                        @if(env('PAPARA_TYPE') == 1)
                            @if($transaction->player->external_user_id != $transaction->player->first_name)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="{{ $transaction->player->first_name . ' ' . $transaction->player->last_name }}" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @else
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @endif
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input class="form-control" type="text" name="process_account_name" autocomplete="off" placeholder="Yatırım Yapılan Hesap Adı" required />
                                    <p style="opacity:.7;"><small>— Size paylaşılan hesap sahibinin Adı ve Soyadını yazmalısınız...</small></p>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="input-group mb-3">
                                    <input class="form-control" type="text" name="identity_number" autocomplete="off" placeholder="Kimlik Numarası" value="{{ !empty($transaction->player->identity_number) ? $transaction->player->identity_number : '' }}" required />
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="input-group mb-3">
                                    <input class="form-control" type="text" name="customer_note" autocomplete="off" placeholder="Kullanıcı Notu (İsteğe Bağlı)" />
                                </div>
                            </div>
                        @endif

                        @if(env('PAPARA_TYPE') == 2)
                            @if($transaction->sites->is_pp_type == 0)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <select class="form-control" name="site-transfer-type">
                                            <option value=''>Yatırım Aralığı Seçiniz</option>
                                            <option value='iban'>IBAN ile Yatırım | 100.00 - 9999.00</option>
                                            <option value='papara'>Papara ile Yatırım | 9999.00 - 100000.00</option>
                                        </select>
                                        <p style="opacity:.7;"><small>— Papara üzerinde IBAN'a transfer gönderim limitiniz dolmadıysa daha kolay ödeme yapabilirsiniz.</small></p>
                                    </div>
                                </div>
                            @else
                                <input type="hidden" name="site-transfer-type" value=""/>
                            @endif

                            @if($transaction->player->external_user_id != $transaction->player->first_name)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="{{ $transaction->player->first_name . ' ' . $transaction->player->last_name }}" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @else
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @endif
                        @endif

                        @if(env('PAPARA_TYPE') == 3)
                            @if($transaction->sites->is_pp_type == 0)
                            <div class="col-md-12">
                                <div class="form-group">
                                    <select class="form-control" name="site-transfer-type">
                                        <option value=''>Yatırım Aralığı Seçiniz</option>
                                        <option value='iban'>IBAN ile Yatırım | 100.00 - 9999.00</option>
                                        <option value='papara'>Papara ile Yatırım | 9999.00 - 100000.00</option>
                                    </select>
                                    <p style="opacity:.7;"><small>— Papara üzerinde IBAN'a transfer gönderim limitiniz dolmadıysa daha kolay ödeme yapabilirsiniz.</small></p>
                                </div>
                            </div>
                            @else
                                <input type="hidden" name="site-transfer-type" value=""/>
                            @endif

                            @if($transaction->player->external_user_id != $transaction->player->first_name)
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="{{ $transaction->player->first_name . ' ' . $transaction->player->last_name }}" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @else
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input class="form-control" type="text" name="site-fullname" autocomplete="off" placeholder="Adınız ve Soyadınız" value="" required />
                                        <p style="opacity:.7;"><small>— Adınızı ve Soyadınızı hesabınızda olduğu gibi yazmalısınız...</small></p>
                                    </div>
                                </div>
                            @endif
                        @endif

                        <div class="col-md-12">
                            <div class="input-group mb-3">
                                <input class="form-control" type="text" name="deposit-amount" autocomplete="off" placeholder="Miktar" min="1" value="" required />
                                <div class="input-group-append">
                                    <span class="input-group-text"><small>TL</small></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="site-userID" value="{{ $transaction->player->external_user_id }}"/>
                    <input type="hidden" name="site-data" value=""/>
                    <input type="hidden" name="site-trx" value="{{ $transaction->external_transaction_id }}"/>
                    <input type="hidden" name="site-id" value="{{ $transaction->api_id }}"/>
                    <input type="hidden" name="method-id" value="{{ $paymentMethod->id }}"/>
                    <input type="hidden" name="hash" value="{{ $payHash }}"/>
                    <br>
                    <button class="btn btn-warning btn-block maksiButton" type="submit">
                        <span>İşleme Başla! <i class="fa fa-long-arrow-right m-l-7" aria-hidden="true"></i></span>
                    </button>
                </form>
            </div>
            <hr>
            <div class="row justify-content-between" style="opacity:.7;">
                <div class="col-md-6"><small>{{ $transaction->sites->name }}</small></div>
                <div class="col-md-6" style="text-align:right;">
                    <a href="{{ env('PAY_WEBSITE_URL') }}" target="_blank">
                        <img style="max-height: 25px;"src="{{ env('PAY_WEBSITE_LOGO') }}" alt="© {{ env('PAY_WEBSITE_NAME') }}">
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="/v2/js/all.js"></script>
<script src="/v2/js/moment.min.js"></script>
<script src="/v2/js/daterangepicker.js"></script>
<script src="/v2/js/jquery.inputmask.js"></script>
<script src="/v2/js/jquery.inputmask.date.extensions.js"></script>
<script src="/v2/js/jquery.inputmask.extensions.js"></script>
<script src="/v2/js/app.js?ver=2.713"></script>
<script type="text/javascript">
    $(function () {
        $("[data-mask]").inputmask();

        @if(!empty($transaction->share_bank_account_id))
            PaparaCheckSession();
        @endif

        @if(!empty($transaction->player_approved))
            PaparaCheckSession();
        @endif
    });

    function b64DecodeUnicode(str) {
        return decodeURIComponent(atob(str).split('').map(function(c) {
            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
        }).join(''));
    }
</script>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-178268478-1"></script>
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'UA-178268478-1');
</script>
</body>
</html>
