@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="animatedParent animateOnce">
            <div class="container-fluid my-3">
                <div class="row">
                    @if($message = Session::get('error'))
                    <div class="col-md-12">
                        <div class="alert alert-danger alert-block">
                            <button type="button" class="close" data-dismiss="alert">×</button>
                            <strong>{{ $message }}</strong>
                        </div>
                    </div>
                    @endif

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body b-b">
                                <form method="POST" action="">
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                                    <div class="form-group">
                                        <label for="type_id" class="col-form-label">Tip</label>
                                        <select id="type_id" name="type_id" class="form-control">
                                            <option value="1" {{ $detail->type_id == 1 ? 'selected' : '' }}>Havale/EFT</option>
                                            <option value="2" {{ $detail->type_id == 2 ? 'selected' : '' }}>PaPara</option>
                                            <option value="3" {{ $detail->type_id == 3 ? 'selected' : '' }}>CMT Cüzdan</option>
                                            <option value="4" {{ $detail->type_id == 4 ? 'selected' : '' }}>PepPara</option>
                                            <option value="5" {{ $detail->type_id == 5 ? 'selected' : '' }}>Param Havale</option>
                                            <option value="6" {{ $detail->type_id == 6 ? 'selected' : '' }}>Param Card</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="bank_id" class="col-form-label">Banka Adı</label>
                                        <select id="bank_id" name="bank_id" class="form-control">
                                            <option value="0">Seçiniz</option>
                                            @foreach($banks as $bank)
                                                <option value="{{ $bank->id }}"  {{ $detail->bank_id == $bank->id ? 'selected' : '' }}>{{ $bank->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="color: red">Not: Lütfen tip Havale/EFT değilse banka seçimi yapmayınız.</span>
                                    </div>

                                    <div class="form-group">
                                        <label for="type_id" class="col-form-label">PaPara IBAN?</label>
                                        <select id="type_id" name="papara_iban" class="form-control">
                                            <option value="0" {{ $detail->is_pp_iban == 0 ? 'selected' : '' }}>Hayır</option>
                                            <option value="1" {{ $detail->is_pp_iban == 1 ? 'selected' : '' }}>Evet</option>
                                        </select>
                                        <span style="color: red">Not: Eğer ki papara iban seçeneği için hesap ekliyorsanız bu alana evet olarak seçiniz.</span>
                                    </div>

                                    <div class="form-group">
                                        <label for="api_id" class="col-form-label">Site</label>
                                        <select id="api_id" name="api_id[]" class="form-control" size="8" multiple="multiple" tabindex="1">
                                            @php
                                                $explode = explode(',', $detail->api_id);
                                            @endphp
                                            @foreach($sites as $site)
                                                <option value="{{ $site->id }}" {{ in_array($site->id, $explode) ? 'selected' : '' }}>{{ $site->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="color: red">Not: Site seçimi yapılmaz ise tüm her siteye gösterilmektedir. CTRL tuşuna basılı tutarak birden fazla seçebilirsiniz.</span>
                                    </div>

                                    <div class="form-group">
                                        <label for="account_number" class="col-form-label">Hesap Numarası</label>
                                        <input type="text" class="form-control" id="account_number" name="account_number" value="{{ $detail->account_number }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="branch_code" class="col-form-label">Şube Kodu</label>
                                        <input type="text" class="form-control" id="branch_code" name="branch_code" value="{{ $detail->branch_code }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="account_owner" class="col-form-label">Hesap Sahibi</label>
                                        <input type="text" class="form-control" id="account_owner" name="account_owner" value="{{ $detail->account_owner }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="iban" class="col-form-label">IBAN</label>
                                        <input type="text" class="form-control" id="iban" name="iban" value="{{ $detail->iban }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="total_limit" class="col-form-label">Toplam Maksimum Limit</label>
                                        <input type="text" class="form-control" id="total_limit" name="total_limit" value="{{ $detail->total_limit }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="daily_limit" class="col-form-label">Günlük Limit</label>
                                        <input type="text" class="form-control" id="daily_limit" name="daily_limit" value="{{ $detail->daily_limit }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="process_limit" class="col-form-label">İşlem Limiti</label>
                                        <input type="text" class="form-control" id="process_limit" name="process_limit" value="{{ $detail->process_limit }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="deposit_range_id" class="col-form-label">Yatırım Aralığı</label>
                                        <select id="deposit_range_id" name="deposit_range_id" class="form-control">
                                            <option value="0">Seçiniz</option>
                                            @foreach($deposit_range as $dr)
                                                <option value="{{ $dr->id }}"  {{ $detail->deposit_range_id == $dr->id ? 'selected' : '' }}>{{ $dr->name }}</option>
                                            @endforeach
                                        </select>
                                        <span style="color: red">Not: Bu alanı seçmek zorunlu değildir. Seçim yapılmaz ise diğer kriterler ile işlem yapılır.</span>
                                    </div>

                                    <div style="border: 1px solid #e1e8ee;padding: 10px 20px 0px 20px;background: #eee;">
                                        <h3 style="border-bottom: 1px solid #eee;color: darkred;padding-bottom: 5px;">E-Mail Ayarları</h3>

                                        <div class="alert alert-warning" role="alert" style="background: #ffc107;border: 1px solid #FF9800;color: #fff;text-transform: uppercase;">
                                            Eğer ki kullanmak istemiyorsanız boş bırakınız !
                                        </div>

                                        <input type="hidden" name="mail_server_check" value="0" />

                                        <div class="form-group">
                                            <label for="mail_server" class="col-form-label">Servis Sağlayıcı</label>
                                            <select id="mail_server" name="mail_server" class="form-control">
                                                <option value="" {{ empty($detail->mail_server) ? 'selected' : '' }}>Seçiniz</option>
                                                <option value="1" {{ $detail->mail_server == 1 ? 'selected' : '' }}>Yandex</option>
                                                <option value="2" {{ $detail->mail_server == 2 ? 'selected' : '' }}>Gmail</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="mail_username" class="col-form-label">E-Mail Adresi</label>
                                            <input type="text" class="form-control" id="mail_username" name="mail_username" value="{{ $detail->mail_username }}">
                                        </div>

                                        <div class="form-group">
                                            <label for="mail_password" class="col-form-label">Şifre</label>
                                            <input type="text" class="form-control" id="mail_password" name="mail_password" value="{{ $detail->mail_password }}">
                                        </div>

                                        <div class="form-group" id="responseMailServer">
                                            <button type="button" class="btn btn-warning" id="checkMailServer">Test Et</button>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="description" class="col-form-label">Açıklama</label>
                                        <input type="text" class="form-control" id="description" name="description" value="{{ $detail->description }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="admin_note" class="col-form-label">Admin Notu</label>
                                        <input type="text" class="form-control" id="admin_note" name="admin_note" value="{{ $detail->admin_note }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="balance" class="col-form-label">Bakiye</label>
                                        <input type="text" class="form-control" id="balance" name="balance" value="{{ $detail->balance }}">
                                    </div>

                                    <div class="form-group">
                                        <label for="status" class="col-form-label">Durum</label>
                                        <select id="status" name="status" class="form-control">
                                            <option value="1" {{ $detail->status == 1 ? 'selected' : '' }}>Aktif</option>
                                            <option value="0" {{ $detail->status == 0 ? 'selected' : '' }}>Pasif</option>
                                            <option value="2" {{ $detail->status == 2 ? 'selected' : '' }}>Kullanım Dışı</option>
                                        </select>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Güncelle</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('panel.includes.footer')
